package com.companyname.simplebeans.simplebeaniface.common.enums;

import java.util.HashMap;
/**
 *                             NOTICE
 *             COPYRIGHT(c) 2016 ObjectRiver, Inc.
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 *
 *      This program is confidential, proprietary, and a trade
 *  secret of ObjectRiver, Inc. The receipt or possession of
 *     this program does not convey any rights to reproduce or
 *      disclose its contents, or to manufacture, use, or sell
 *       anything that it may describe, in whole or in part,
 *  without the specific written consent of ObjectRiver, Inc.
 *
 */
public enum MyThings {
    Car(1),
    House(2),
    Jeep(3),
    AnotherJeep(4);

    public final int intValue;
    private MyThings(int value) {
        this.intValue = value;
    }

    public static MyThings getInstance() { // Used for method template
        return AnotherJeep;
    }

    // enum.valueOf() throws Exception :{
    static private HashMap<Object,MyThings> map = new HashMap();
    static {
        map.put("car",Car);
        map.put(1,Car);
        map.put("house",House);
        map.put(2,House);
        map.put("jeep",Jeep);
        map.put(3,Jeep);
        map.put("anotherjeep",AnotherJeep);
        map.put(4,AnotherJeep);
    }
    public static boolean contains(String name) {
        if(name==null) return false;
        return map.keySet().contains(name.toLowerCase());
    }
    public static MyThings get(Object value) {
        if(value==null) return null;
        if(value instanceof MyThings)
            return (MyThings)value;
        if(value instanceof String )
            return map.get(((String)value).toLowerCase());
        return map.get(value);
    }
}
