package com.companyname.simplebeans.simplebeaniface.common.json;

import com.objectriver.microservices.rest.RestException;
import com.objectriver.microservices.things.RestDocument;
import com.objectriver.microservices.things.RestList;
import com.objectriver.microservices.things.RestMember;
import com.objectriver.microservices.things.RestObject;
import com.objectriver.microservices.things.RestDictionary;
import com.objectriver.microservices.things.abstracts.RestScope;
import com.objectriver.microservices.things.abstracts.RestThing;
import com.objectriver.microservices.things.json.RestJsonVisitor;

import java.io.IOException;
import java.io.OutputStream;

/**
 *                             NOTICE
 *             COPYRIGHT(c) 2016 ObjectRiver, Inc.
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 *
 *      This program is confidential, proprietary, and a trade
 *  secret of ObjectRiver, Inc. The receipt or possession of
 *     this program does not convey any rights to reproduce or
 *      disclose its contents, or to manufacture, use, or sell
 *       anything that it may describe, in whole or in part,
 *  without the specific written consent of ObjectRiver, Inc.
 *
 */

/**
 * This class is created for special cases needed in marshalling JSON.
 * Created from createonce template.
 */
public class SimpleBeanIfaceJsonVisitor extends RestJsonVisitor {
    /**
     * Alternative to RestJsonVisitor.execute(RestThing thing)
     */
    public static String execute(RestThing thing)  throws RestException {
        SimpleBeanIfaceJsonVisitor visitor = new SimpleBeanIfaceJsonVisitor();
        thing.visit(visitor);
        if(visitor.excep!=null)
            throw visitor.excep;
        return visitor.buffer.toString();
    }
    /**
     * Alternative to RestJsonVisitor.execute(RestThing thing, OutputStream stream)
     */
    public static void execute(RestThing thing, OutputStream stream) throws RestException {
        try {
            SimpleBeanIfaceJsonVisitor visitor = new SimpleBeanIfaceJsonVisitor();
            visitor.outStream = stream;
            thing.visit(visitor);
            if (visitor.excep != null)
                throw visitor.excep;
        }
        finally {
            try { stream.close();} catch (IOException ex) {}
        }
    }

    /**
     * Methods to overide.
     */
    public boolean beginVisitOfRestDocument(RestDocument value) {
        return super.beginVisitOfRestDocument(value);
    }
    public void endVisitOfRestDocument(RestDocument value) {
        super.endVisitOfRestDocument(value);
    }
    public boolean beginVisitOfRestObject(RestObject value) {
        return super.beginVisitOfRestObject(value);
    }
    public void endVisitOfRestObject(RestObject value) {
        super.endVisitOfRestObject(value);
    }
    public boolean beginVisitOfRestDictionary(RestDictionary value) {
        return super.beginVisitOfRestDictionary(value);
    }
    public void endVisitOfRestDictionary(RestDictionary value) {
        super.endVisitOfRestDictionary(value);
    }
    public boolean beginVisitOfRestScope(RestScope value) {
        return super.beginVisitOfRestScope(value);
    }
    public void endVisitOfRestScope(RestScope value) {
        super.endVisitOfRestScope(value);
    }
    public boolean beginVisitOfRestList(RestList value) {
        return super.beginVisitOfRestList(value);
    }
    public void endVisitOfRestList(RestList value) {
        super.endVisitOfRestList(value);
    }
    public boolean beginVisitOfRestMember(RestMember value) {
        return super.beginVisitOfRestMember(value);
    }
    public void endVisitOfRestMember(RestMember value) {
        super.endVisitOfRestMember(value);
    }
}
