package com.companyname.simplebeans.simplebeaniface.server.services;
/**
 *                             NOTICE
 *             COPYRIGHT(c) 2016 ObjectRiver, Inc.
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 *
 *      This program is confidential, proprietary, and a trade
 *  secret of ObjectRiver, Inc. The receipt or possession of
 *     this program does not convey any rights to reproduce or
 *      disclose its contents, or to manufacture, use, or sell
 *       anything that it may describe, in whole or in part,
 *  without the specific written consent of ObjectRiver, Inc.
 *
 *  This class is generated from a createonce template, so it can be modified
 *  and will not be overwritten.
 */

import com.companyname.simplebeans.simplebeaniface.common.beans.Simple;
import com.companyname.simplebeans.simplebeaniface.common.enums.*;
import com.companyname.simplebeans.common.visitors.SimpleBeansFixupVisitor;
import com.companyname.simplebeans.common.SimpleBeanException;

import com.objectriver.microservices.rest.RestException;
import com.objectriver.microservices.things.*;
import com.objectriver.microservices.things.json.RestJsonParser;
import com.objectriver.microservices.things.json.RestJsonVisitor;

import com.objectriver.microservices.util.RandomData;
import org.apache.log4j.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.*;
import javax.ws.rs.core.*;

import java.util.*;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.sql.Date;

/**
    @Path("simpleBeanTrip")
    @Produces(JSON)
    @Consumes(JSON)
    @POST Simple simpleBeanTrip( @In Simple arg ) throws SimpleBeanException;
 */

@Path("simpleBeanTrip")
public class SimpleBeanTrip {
    private static Logger log = Logger.getLogger(SimpleBeanTrip.class);
    private @Context HttpServletRequest request;

    @POST
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    public Response simpleBeanTrip(    )
    {
        Response.ResponseBuilder builder = null;
        try {
            Simple arg = RestJsonParser.parseJsonObject(new Simple("arg"), request.getInputStream());
            arg = SimpleBeansFixupVisitor.execute(arg);

            /**
             * Call implementation method
             */
            Simple result = simpleBeanTrip_impl(arg);

            /**
             * Response
             */
            builder = Response.ok(Response.Status.OK)
                    .entity(RestJsonVisitor.execute(result))
                    .type(MediaType.APPLICATION_JSON_TYPE)
                    ;

        }
        /**
         * Handle all custom exception logic here. We are choosing to return an error document while keeping the 200 OK code.
         */
        catch(SimpleBeanException ex) {
            log.error(ex.getMessage());
            try {
                builder = Response.status(420)
                        .entity(ex.toString())
                        .type(MediaType.APPLICATION_JSON_TYPE)
                ;
            }
            catch(Exception e){}
        }
        catch(Exception ex) { // Unchecked
            log.error(ex.getMessage());
            ex.printStackTrace();
            try {
                RestDocument exceptionDoc = (RestDocument)new RestDocument()
                    .put("statusCode",500)
                    .put("message","Server simpleBeanTrip Unknown Exception: " + ex.getMessage())
                    .put("trace",ex.getStackTrace().toString());
                builder = Response.status(500)
                        .entity(exceptionDoc.toString())
                        .type(MediaType.APPLICATION_JSON_TYPE)
                ;
            }
            catch(Exception e){}
        }
        finally {
        }
        return builder.build();
    }

    /**
     * Implementation
     */
    public static Simple simpleBeanTrip_impl( Simple arg ) throws SimpleBeanException
    {
        try {
            System.out.println("Entering method simpleBeanTrip()");
            /**
             * Insert Logic Here
             */
            return arg; // round trip
        }
        finally {
             System.out.println("Leaving method simpleBeanTrip()");
        }
    }
    /** DELETEME --- random generator for generating data */
    private static RandomData random = new RandomData();
}
