/**
 *                             NOTICE
 *             COPYRIGHT(c) 2016 ObjectRiver, Inc.
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 *
 *      This program is confidential, proprietary, and a trade
 *  secret of ObjectRiver, Inc. The receipt or possession of
 *     this program does not convey any rights to reproduce or
 *      disclose its contents, or to manufacture, use, or sell
 *       anything that it may describe, in whole or in part,
 *  without the specific written consent of ObjectRiver, Inc.
 *
 *  This class is generated from a createonce template, so it can be modified
 *  and will not be overwritten.
 *
 * To turn on CSRF Cross Site Request Forgery,
 * Add "@HeaderParam(csrfToken) String csrfToken" as method argument in your model
 * that will be the first call to this server. This will generate csrf infrastructure to
 * protect you application from JavaScript hacking.
 * The method with this header should also some kind of addition authentication like login()
 *
 * Example:
 *            @Path("login")
 *            @Consumes(JSON)
 *            @POST void loginMe("@HeaderParam(csrfToken) String csrfToken, @In UserDescription user);
 */
package com.companyname.simplebeans.simplebeaniface.server.servlet;

import org.apache.log4j.Logger;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@WebFilter(urlPatterns = {
        "/SimpleBeanIface/*"},
        filterName = "SimpleBeanIface Filter"
)
public class SimpleBeanIfaceFilter implements Filter {
    private static final Logger log = Logger.getLogger(SimpleBeanIfaceFilter.class);

    @Override
    public void init(FilterConfig config) {
        log.info("SimpleBeanIfaceFilter Initializing filter.");
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain)
            throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) req;
        HttpServletResponse response = (HttpServletResponse) res;

        // Proceed.
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
    }

    /**
     * Helper method to return the client's IP address.
     */
    private static String getClientIp(HttpServletRequest request) {
        String ip = request.getHeader("X-FORWARDED-FOR");
        if (ip == null || ip.isEmpty()) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}
