package com.companyname.beans.client.impl;

import com.companyname.beans.client.*;
import com.companyname.beans.common.BeansLogger;
import com.companyname.beans.common.beans.TestBean;
import com.companyname.beans.common.beans.TestBeanFactory;
import com.companyname.beans.common.enums.MyMessageType;
import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.webrpc.exception.WebRpcTimedout;
import com.objectriver.runtime.webrpc.exception.WebRpcClientException;
import com.objectriver.runtime.webrpc.exception.beans.WebSocketException;
import com.objectriver.runtime.webrpc.properties.WebRpcProperties;

import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.logging.Level;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class BeansMain {
    public static void main(String[] args) {
        //BeansLogger.clogger.setLevel(Level.FINE);
        //BeansLogger.mlogger.setLevel(Level.FINER);
        BeansClient client = null;
        try {
            Properties props = WebRpcProperties.getProperties("webrpc.properties");
            String url = "ws://"+props.getProperty("webrpc.host")+":"+props.getProperty("webrpc.port")
                +"/BeansWebApp" // RootWebServer - This may depend on web server deployment, and type of web server
                +'/' + "Test"   // RootContext
                +'/' + "Beans" // If URI contains WebSocket Path templates you may want to modify this.
                ;
            client = BeansClient.connect(url);
            /**
             * insert client code here
             */
            TestBean bean = TestBeanFactory.valueOf(new String[]{"one", "two"}, 2);
            Boolean result = client.beanMethod(bean, new TestBean[]{bean, bean}, MyMessageType.Full_instance);
            Assert.assertTrue(result != null && result.booleanValue());
        }
        catch(IOException ex) {
            System.err.println(ex.getMessage());
        }
        catch(DeploymentException ex) {
            System.err.println(ex.getMessage());
        }
        catch(URISyntaxException ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcTimedout ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcClientException ex) {
            ex.printCauseTrace();
        }
        catch(WebSocketException ex) {
            ex.printCauseTrace();
        }
        finally {
            try {
                if(client!=null) client.disconnect();
            }
            catch(IOException ex) {}
        }
    }
}
