package com.companyname.beans.server.impl;
/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */

import com.companyname.beans.common.*;
import com.companyname.beans.common.beans.*;
import com.companyname.beans.common.enums.*;

import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import java.sql.*;
import java.util.Map;
import java.util.HashSet;

public class BeanIfaceServerSingletonImpl_V1 implements BeanIfaceServerInterface_V1,ServerEndPointInterface {
    private static BeanIfaceServerSingletonImpl_V1 ourInstance;
    protected BeanIfaceServerSingletonImpl_V1() {
    }
    /**
     * This is the standard use of the Singleton Design pattern to retrieve a single multithreaded instance
     * of the interface's implementation.
     */
    public synchronized static BeanIfaceServerSingletonImpl_V1 getInstance() {
        if (ourInstance == null) {
            ourInstance = new BeanIfaceServerSingletonImpl_V1();
        }
        return ourInstance;
    }
    /**
     * currentSession is a thread local variable that identifys the session to the current client.
     * To create a callback Stub to the client execute the following code.
     *      SingleClientStub stub = new SingleClientStub(currentSession.get());
     */
    public static ThreadLocal<Session> currentSession=new ThreadLocal<Session>();

    /**
     * sessionList is a list of all session clients to the singleton. To send messages to all client
     * except your self, code the following.
     *      Session mySession = currentSession.get();
     *      Iterator<Session> iter = sessionList.iterator();
     *      while(iter.hasNext()) {
     *          Session clientSession = iter.next();
     *          if(mySession==clientSession) continue;
     *          ProtoServerStub stub = new ProtoServerStub(currentSession.get());
     *          stub.method(....);
     *      }
     */
    HashSet<Session> sessionList = new HashSet();

    /**
     * Implementation WebSocket endpoint routines.
     */
    public void onOpen(Session session, EndpointConfig endpointConfig) {
        sessionList.add(session); // save client sessions to list.
    }
    public void onClose(Session session, CloseReason closeReason) {
        sessionList.remove(session); // remove client seesion from list.
    }
    public void onError(Session session, Throwable thr) {
        System.out.println(thr.getMessage());
        thr.printStackTrace();
    }

    /**
     * Implement your methods here!
     */
    public Boolean beanMethod( TestBean arg, TestBean[] argArray, MyMessageType option) throws BeanException {
        System.out.println("Inside beanMethod method");
        if(arg==null) throw new BeanException("beanMethod argument arg was null!");
        if(argArray==null) throw new BeanException("beanMethod argument argArray was null!");
        if(argArray.length!=2) throw new BeanException("beanMethod argument argArray size was not 2!");
        validatebean(arg);
        validatebean(argArray[0]);
        validatebean(argArray[1]);
        return true;
    }
    private void validatebean(TestBean bean) throws BeanException {
        Integer member2 = bean.getMember2();
        String[] member1 = bean.getMember1();
        if(member2==null) throw new BeanException("TestBean member2 was null!");
        if(member1==null) throw new BeanException("TestBean member1 was null!");
        if(member1.length!=member2)throw new BeanException("member1.length is not equal to member2");
        if(!member1[0].equals("one")) throw new BeanException("TestBean member1[0] does not equal one");
        if(!member1[1].equals("two")) throw new BeanException("TestBean member1[1] does not equal two");
    }
}
