package com.companyname.binaryparam.client.impl;

import com.companyname.binaryparam.client.*;
import com.companyname.binaryparam.common.BinaryParamLogger;
import com.companyname.binaryparam.common.beans.BinaryException;
import com.companyname.binaryparam.common.documents.Method2ResponseDocument_V1;
import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.webrpc.exception.WebRpcTimedout;
import com.objectriver.runtime.webrpc.exception.WebRpcClientException;
import com.objectriver.runtime.webrpc.exception.beans.WebSocketException;
import com.objectriver.runtime.webrpc.properties.WebRpcProperties;

import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.WebSocketContainer;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.logging.Level;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class BinaryParamMain {
    public static void main(String[] args) {
        //BinaryParamLogger.clogger.setLevel(Level.FINE);
        //BinaryParamLogger.mlogger.setLevel(Level.FINER);
        BinaryParamClient client = null;
        try {
            Properties props = WebRpcProperties.getProperties("webrpc.properties");
            String url = "ws://"+props.getProperty("webrpc.host")+":"+props.getProperty("webrpc.port")
                +"/BinaryParamWebApp" // RootWebServer - This may depend on web server deployment, and type of web server
                +'/' + "Test"   // RootContext
                +'/' + "BinaryParam" // If URI contains WebSocket Path templates you may want to modify this.
                ;
            client = BinaryParamClient.connect(url);
            /**
             * insert client code here
             */
            /**
             * Test1: SyncMethod void method1([in] BinaryStream input) raises BinaryException;
             */
            try{
                OutputStream ous = client.getSession().getBasicRemote().getSendStream();
                client.method1(ous);
                DataOutputStream dos = new DataOutputStream(ous);
                dos.writeInt(1234);
                dos.writeInt(5678);
                dos.writeInt(1234);
                dos.close();
                client.method1_wait();
            }catch(IOException ex){
                System.err.println(ex.getMessage());
            }catch(BinaryException ex){
                Assert.fail();
            }

            /**
             * Test2: SyncMethod void method2([inout] String str, [in] BinaryStream input);
             */
            String[] strs = {"Objectriver"};
            try {
                OutputStream ous = client.getSession().getBasicRemote().getSendStream();
                client.method2(strs, ous);
                DataOutputStream dos = new DataOutputStream(ous);
                dos.writeInt(123);
                dos.writeInt(456);
                dos.writeInt(789);
                dos.close();
                Method2ResponseDocument_V1 result = client.method2_wait();
                String strOut[] = result.getStr();
                Assert.assertTrue(strOut[0]!=null);
                Assert.assertTrue(strOut[0].equals("Steve"));
            } catch (IOException ex) {
                System.err.println(ex.getMessage());
            } catch (BinaryException ex) {
                Assert.fail();
            }

            /**
             * Test3: SyncMethod void method3([in] String str, [in] BinaryStream input, [in] Long arg3);
             */
            String str = "Objectriver";
            long arg3 = 373122431;
            try{
                OutputStream ous = client.getSession().getBasicRemote().getSendStream();
                client.method3(str, ous, arg3);
                DataOutputStream dos = new DataOutputStream(ous);
                dos.writeInt(123);
                dos.writeInt(456);
                dos.writeInt(789);
                dos.close();
                client.method3_wait();
            }catch(IOException ex){
                System.err.println(ex.getMessage());
            }catch(BinaryException ex){
                Assert.fail();
            }
        }
        catch(IOException ex) {
            System.err.println(ex.getMessage());
        }
        catch(DeploymentException ex) {
            System.err.println(ex.getMessage());
        }
        catch(URISyntaxException ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcTimedout ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcClientException ex) {
            ex.printCauseTrace();
        }
        catch(WebSocketException ex) {
            ex.printCauseTrace();
        }
        finally {
            try {
                if(client!=null) client.disconnect();
            }
            catch(IOException ex) {}
        }
    }
}
