package com.companyname.chat.client.impl;

import com.companyname.chat.client.*;
import com.companyname.chat.common.ChatLogger;
import com.companyname.chat.common.beans.ChatException;
import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.webrpc.exception.WebRpcTimedout;
import com.objectriver.runtime.webrpc.exception.WebRpcClientException;
import com.objectriver.runtime.webrpc.exception.beans.WebSocketException;
import com.objectriver.runtime.webrpc.properties.WebRpcProperties;
import junit.framework.TestCase;
import junit.textui.TestRunner;

import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.logging.Level;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class ChatMain extends TestCase{

    public static ChatClient client = null;

    public static void main(String[] args) {
        TestRunner.run(ChatMain.class);
    }

    public void setUp() {
        try {
            Properties props = WebRpcProperties.getProperties("webrpc.properties");
            String url = "ws://" + props.getProperty("webrpc.host") + ":" + props.getProperty("webrpc.port")
                    + "/ChatWebApp" // RootWebServer - This may depend on web server deployment, and type of web server
                    + "/Test"   // RootContext
                    + "/Chat" // If URI contains WebSocket Path templates you may want to modify this.
                    ;
            client = ChatClient.connect(url);
        } catch (IOException ex) {
            System.err.println(ex.getMessage());
        } catch (DeploymentException ex) {
            System.err.println(ex.getMessage());
        } catch (URISyntaxException ex) {
            System.err.println(ex.getMessage());
        } catch (WebRpcTimedout ex) {
            System.err.println(ex.getMessage());
        } catch (WebRpcClientException ex) {
            ex.printCauseTrace();
        } catch (WebSocketException ex) {
            ex.printCauseTrace();
        }
    }

    public static void setClient(ChatClient client) {
        ChatMain.client = client;
    }

    public static void test_main() {
        try {
            /**
             * insert client code here
             */
            try {
                client.addGroup("ObjectRiver");
                client.login("ObjectRiver", "Steve");
                client.sendMessage("Hello World!");
                client.logoff();
            } catch (ChatException ex) {
                ex.printCauseTrace();
            }

        } catch (ChatException ex) {
            System.err.println(ex.getMessage());
        } catch (WebRpcTimedout ex) {
            System.err.println(ex.getMessage());
        } catch (WebRpcClientException ex) {
            ex.printCauseTrace();
        } catch (WebSocketException ex) {
            ex.printCauseTrace();
        }
        try {
            client.disconnect();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ChatClient connect(String path)
            throws IOException, DeploymentException, URISyntaxException {
        WebSocketContainer wsc = ContainerProvider.getWebSocketContainer();
        ChatClient client = new ChatClient();
        wsc.connectToServer(client, new URI(path));
        return client;
    }
}

