package com.companyname.chat.server.impl;
/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */

import com.companyname.chat.common.ChatIfaceServerInterface_V1;
import com.companyname.chat.common.ServerEndPointInterface;
import com.companyname.chat.common.beans.ChatException;
import com.companyname.chat.server.ChatServerStub_V1;

import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import java.util.*;

public class ChatIfaceServerSingletonImpl_V1 implements ChatIfaceServerInterface_V1, ServerEndPointInterface {
    protected ChatIfaceServerSingletonImpl_V1() {
    }

    /**
     * This is the standard use of the Singleton Design pattern to retrieve a single multithreaded instance
     * of the interface's implementation.
     */
    private static ChatIfaceServerSingletonImpl_V1 ourInstance;

    public synchronized static ChatIfaceServerSingletonImpl_V1 getInstance() {
        if (ourInstance == null) {
            ourInstance = new ChatIfaceServerSingletonImpl_V1();
        }
        return ourInstance;
    }

    /**
     * currentSession is a thread local variable that identifys the session to the current client.
     * To create a callback Stub to the client execute the following code.
     * ChatServerStub stub = new ChatServerStub(currentSession.get());
     */
    public static ThreadLocal<Session> currentSession = new ThreadLocal<Session>();

    /**
     * sessionList is a list of all session clients to the singleton. To send messages to all client
     * except your self, code the following.
     * Session mySession = currentSession.get();
     * Iterator<Session> iter = sessionList.iterator();
     * while(iter.hasNext()) {
     * Session clientSession = iter.next();
     * if(mySession==clientSession) continue;
     * ProtoServerStub stub = new ProtoServerStub(currentSession.get());
     * stub.method(....);
     * }
     */
    protected HashSet<Session> sessionList = new HashSet();
    private LinkedList<String> groups = new LinkedList<String>();
    private HashMap<String,HashSet<Session>> groupSessionsMap = new HashMap<String,HashSet<Session>>();

    /**
     * Implementation WebSocket endpoint routines.
     */
    public void onOpen(Session session, EndpointConfig endpointConfig) {
        sessionList.add(session); // save client sessions to list.
        /**
         * Add group to the groupList
         */
//        ChatLogger.slogger.setLevel(Level.FINE);
//        ChatLogger.mlogger.setLevel(Level.FINER);
    }

    public void onClose(Session session, CloseReason closeReason) {
        sessionList.remove(session); // remove client seesion from list.
    }

    public void onError(Session session, Throwable thr) {
        System.out.println(thr.getMessage());
        thr.printStackTrace();
    }

    /**
     * Implement your methods here!
     */

    /**
     * syncmethod Boolean login( [in] String group, [in] String user ) throws ChatException {};
     */
    public synchronized Boolean login(String group, String user) throws ChatException {
        System.out.println("Inside login method");
        System.out.println("group: " + group);
        System.out.println("user: " + user);
        if(!groups.contains(group)) {
            throw new ChatException("Group "+group+" does not exist!");
        }
        currentSession.get().getUserProperties().put("user",user);
        currentSession.get().getUserProperties().put("group",group);
        synchronized (groupSessionsMap) {
            if(!groupSessionsMap.keySet().contains(group)) {
                groupSessionsMap.put(group,new HashSet<Session>());
            }
            HashSet<Session> set = groupSessionsMap.get(group);
            set.add(currentSession.get());
        }
        sendMessage("Logged in");
        return true;
    }

    /**
      * asyncmethod void logoff ) {};
      */
     public void logoff() {
         System.out.println("Inside logoff method");
         String group = (String) currentSession.get().getUserProperties().get("group");
         synchronized (groupSessionsMap) {
             HashSet<Session> set = groupSessionsMap.get(group);
             if(set!=null) set.remove(currentSession.get());
         }
         sendMessage("Logged off");
     }

    /**
     * syncmethod String[] listGroups ) throws ChatException {};
     */
    public String[] listGroups() throws ChatException {
        System.out.println("Inside listGroups method");
        for(String group: groups){
            System.out.println(group);
        }
        return groups.toArray(new String[]{});
    }

    /**
    * syncmethod void addGroup( [in] String group ) throws ChatException {};
    */
    public void addGroup(String group) {
        System.out.println("Inside addGroup method" + group);
        System.out.println("Adding group: " + group);
        groups.add(group);
    }

    /**
     * syncmethod Boolean sendMessage( [in] String message ) throws ChatException {};
     */
    public Boolean sendMessage(String message) throws ChatException {
        System.out.println("Inside sendMessage method:  " + message);
        String group = (String) currentSession.get().getUserProperties().get("group");
        String user = "[" + currentSession.get().getUserProperties().get("user") + "] ";
        System.out.println(group + user + message);
        synchronized (groupSessionsMap) {
            Iterator<Session> iter = groupSessionsMap.get(group).iterator();
            while (iter.hasNext()) {
                Session clientSession = iter.next();
                if (currentSession.get() == clientSession) continue;
                ChatServerStub_V1 stub = new ChatServerStub_V1(clientSession);
                stub.displayMessage(user + message + "\n");
            }
        }
        return true;
    }
}
