package com.companyname.enums.client.impl;

import com.companyname.enums.client.*;
import com.companyname.enums.common.EnumsLogger;
import com.companyname.enums.common.beans.EnumsException;
import com.companyname.enums.common.beans.KidsAndPet;
import com.companyname.enums.common.enums.Flintstones;
import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.webrpc.exception.WebRpcTimedout;
import com.objectriver.runtime.webrpc.exception.WebRpcClientException;
import com.objectriver.runtime.webrpc.exception.beans.WebSocketException;
import com.objectriver.runtime.webrpc.properties.WebRpcProperties;

import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.logging.Level;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class EnumsMain {
    public static void main(String[] args) {
        //EnumsLogger.clogger.setLevel(Level.FINE);
        //EnumsLogger.mlogger.setLevel(Level.FINER);
        EnumsClient client = null;
        try {
            Properties props = WebRpcProperties.getProperties("webrpc.properties");
            String url = "ws://"+props.getProperty("webrpc.host")+":"+props.getProperty("webrpc.port")
                +"/EnumsWebApp" // RootWebServer - This may depend on web server deployment, and type of web server
                +'/' + "Test"   // RootContext
                +'/' + "Enums" // If URI contains WebSocket Path templates you may want to modify this.
                ;
            client = EnumsClient.connect(url);
            /**
             * insert client code here
             */
            /**
             * Test: syncmethod KidsAndPet meetTheFlintstones( [in] Flintstones[] flintstones ) throws EnumsException {};
             */
            Flintstones[] flintstoneses = {Flintstones.Fred_instance, Flintstones.Wilma_instance, Flintstones.Pebbles_instance, Flintstones.Dino_instance, Flintstones.Barney_instance, Flintstones.Betty_instance, Flintstones.Bambam_instance};
            KidsAndPet mKidsAndPet;
            try {
                mKidsAndPet = client.meetTheFlintstones(flintstoneses);
                if(mKidsAndPet.getPet() != Flintstones.Dino_instance) throw new EnumsException("mKidsAndPet.getPet() != Flintstones.Dino_instance");
            } catch (EnumsException ex) {
                Assert.fail(ex.getMessage());
            }
        }
        catch(IOException ex) {
            System.err.println(ex.getMessage());
        }
        catch(DeploymentException ex) {
            System.err.println(ex.getMessage());
        }
        catch(URISyntaxException ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcTimedout ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcClientException ex) {
            ex.printCauseTrace();
        }
        catch(WebSocketException ex) {
            ex.printCauseTrace();
        }
        finally {
            try {
                if(client!=null) client.disconnect();
            }
            catch(IOException ex) {}
        }
    }
}
