package com.companyname.excep.client.impl;

import com.companyname.excep.client.*;
import com.companyname.excep.common.ExcepLogger;
import com.companyname.excep.common.beans.MyException;
import com.companyname.excep.common.beans.MyNoMembersException;
import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.webrpc.exception.WebRpcTimedout;
import com.objectriver.runtime.webrpc.exception.WebRpcClientException;
import com.objectriver.runtime.webrpc.exception.beans.WebSocketException;
import com.objectriver.runtime.webrpc.properties.WebRpcProperties;

import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.logging.Level;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class ExcepMain {
    public static void main(String[] args) {
        //ExcepLogger.clogger.setLevel(Level.FINE);
        //ExcepLogger.mlogger.setLevel(Level.FINER);
        ExcepClient client = null;
        try {
            Properties props = WebRpcProperties.getProperties("webrpc.properties");
            String url = "ws://"+props.getProperty("webrpc.host")+":"+props.getProperty("webrpc.port")
                +"/ExcepWebApp" // RootWebServer - This may depend on web server deployment, and type of web server
                +'/' + "Test"   // RootContext
                +'/' + "Excep" // If URI contains WebSocket Path templates you may want to modify this.
                ;
            client = ExcepClient.connect(url);
            /**
             * insert client code here
             */
            /**
             *Test1: SyncMethod Boolean simpleExcepMethod([in] Integer input ) raises MyException, MyNoMembersException ;
             */
            boolean exception_thrown1 = false;
            try {
                Boolean result = client.simpleExcepMethod(1);
                Assert.fail("exception not thrown");
            } catch (MyException ex) {
                exception_thrown1 = true;
                System.out.println("Expected exception.");
    //                ex.printCauseTrace();
            } catch (MyNoMembersException ex) {
                Assert.fail("expecting MyException");
            }
            Assert.assertTrue(exception_thrown1);
            boolean exception_thrown2 = false;
            try {
                Boolean result = client.simpleExcepMethod(2);
                Assert.fail("exception not thrown");
            } catch (MyException ex) {
                Assert.fail("expecting MyNoMembersException");
            } catch (MyNoMembersException ex) {
                exception_thrown2 = true;
                System.out.println("Expected exception.");
    //                ex.printCauseTrace();
            }
            Assert.assertTrue(exception_thrown2);
            /**
             *Test2: SyncMethod Boolean decodeExcepMethod([in] Integer input ) ;
             */
            boolean wse_thrown = false;
            try {
                Boolean result = client.decodeExcepMethod(777);
            } catch (WebSocketException ex) {
                wse_thrown = true;
                Assert.assertTrue(ex instanceof WebSocketException);
                WebSocketException wse = (WebSocketException) ex;
                Assert.assertTrue(wse.getCauses() != null);
                Assert.assertTrue(wse.getCauses().length == 1);
                Assert.assertTrue(wse.getCauses()[0].getType() != null);
                Assert.assertTrue(wse.getCauses()[0].getType().equals("WebRpcDecodeException"));
            }
            Assert.assertTrue(wse_thrown);
            /**
             *Test3: SyncMethod Boolean nullPointerExcepMethod([in] Integer input )  ;
             */
            try {
                Boolean result = client.nullPointerExcepMethod(2);
                Assert.fail("exception not thrown");
            } catch (Exception ex) {
                System.out.println("Expected exception.");
                Assert.assertTrue(ex instanceof WebSocketException);
                WebSocketException wse = (WebSocketException) ex;
                Assert.assertTrue(wse.getCauses() != null);
                Assert.assertTrue(wse.getCauses().length == 2);
                Assert.assertTrue(wse.getCauses()[1].getType() != null);
                Assert.assertTrue(wse.getCauses()[1].getType().equals("NullPointerException"));
    //                ((WebSocketException)ex).printCauseTrace();
            }
            /**
             *Test4: AsyncMethod void throwthrow( [in] boolean haveClientThrow );
             */
            try{
                client.throwthrow(true);
                Thread.sleep(10000);
            }catch(Exception ex){
                Assert.fail();
            }
        }
        catch(IOException ex) {
            System.err.println(ex.getMessage());
        }
        catch(DeploymentException ex) {
            System.err.println(ex.getMessage());
        }
        catch(URISyntaxException ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcTimedout ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcClientException ex) {
            ex.printCauseTrace();
        }
        catch(WebSocketException ex) {
            ex.printCauseTrace();
        }
        finally {
            try {
                if(client!=null) client.disconnect();
            }
            catch(IOException ex) {}
        }
    }
}
