package com.companyname.excep.server.impl;
/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */

import com.companyname.excep.common.ExcepIfaceServerInterface_V1;
import com.companyname.excep.common.ServerEndPointInterface;
import com.companyname.excep.common.beans.*;
import com.companyname.excep.server.ExcepServerStub_V1;
import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.webrpc.exception.WebRpcDecodeException;
import com.objectriver.runtime.webrpc.exception.beans.WebSocketException;

import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import java.io.IOError;
import java.io.IOException;
import java.sql.*;
import java.util.Map;
import java.util.HashSet;

public class ExcepIfaceServerSessionImpl_V1 implements ExcepIfaceServerInterface_V1,ServerEndPointInterface {
    protected Map<String, Object> userProperties = null;
    protected ExcepServerStub_V1 serverStub = null;
    protected Session session__ = null;
    public ExcepIfaceServerSessionImpl_V1(ExcepServerStub_V1 serverStub) {
        this.serverStub = serverStub;
    }

    /**
     * Implementation WebSocket endpoint routines.
     */
    public void onOpen(Session session, EndpointConfig endpointConfig) {
        this.session__ = session;
        this.userProperties = this.session__.getUserProperties();
    }
    public void onClose(Session session, CloseReason closeReason) {
        this.session__ = null;
    }
    public void onError(Session session, java.lang.Throwable thr) {
        System.out.println(thr.getMessage());
        thr.printStackTrace();
    }

    /**
     * Implement your methods here!
     */
    public Boolean simpleExcepMethod( Integer input) throws MyException , MyNoMembersException {
        System.out.println("Inside simpleExcepMethod method");
        if(input==1)
            throw new MyException(22,new IOException("Dummy IO execption"));
        if(input==2)
            throw new MyNoMembersException("hello exception");
        return true;
    }
    public Boolean decodeExcepMethod( Integer input)  {
        System.out.println("Inside decodeExcepMethod method");
        throw new WebRpcDecodeException("decode exception thrown from method.");
    }
    public Boolean nullPointerExcepMethod( Integer input) {
        String fred=null;
        fred.equals("joe");
        return true;
    }
    public void throwthrow( Boolean throwException) {
        if(throwException) {
            boolean caught = false;
            try {
                serverStub.callbackThrow(throwException);
            }
            catch(MyException ex) {
                System.out.println("Exception caught");
                caught = true;
            }
            Assert.assertTrue(caught);
        }
    }

    @Override
    public void passException(NotThrownException ex) {
    }
}
