package com.companyname.hello.client.impl;

import com.companyname.hello.client.HelloClient;
import com.companyname.hello.common.beans.HelloException;
import com.objectriver.runtime.webrpc.exception.WebRpcClientException;
import com.objectriver.runtime.webrpc.exception.WebRpcTimedout;
import com.objectriver.runtime.webrpc.exception.beans.WebSocketException;
import com.objectriver.runtime.webrpc.properties.WebRpcProperties;

import javax.websocket.DeploymentException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Properties;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class HelloMain {
    public static void main(String[] args) {
        HelloClient client = null;
        try {
            Properties props = WebRpcProperties.getProperties("webrpc.properties");
            String url = "ws://"+props.getProperty("webrpc.host")+":"+props.getProperty("webrpc.port")
                    +"/HelloApp" // RootWebServer - This may depend on web server deployment, and type of web server
                    +"/Test"   // RootContext
                    +"/Hello" // If URI contains WebSocket Path templates you may want to modify this.
                    ;
            client = HelloClient.connect(url);
            try {
                String[] worlds = client.helloMethod("Hello",false);
                for(String world: worlds) {
                    System.out.println(world);
                }
                worlds = client.helloMethod2("Hello",false);
                for(String world: worlds) {
                    System.out.println(world);
                }
                client.helloMethod("Hello",true);
            }
            catch(HelloException ex) {
                System.out.println(ex.getMessage());
            }
            try {
                DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                java.sql.Date date = new java.sql.Date(df.parse("2015-02-13").getTime());
                System.out.println("return date = " + date);
            }
            catch(java.text.ParseException ex) {}

        }
        catch(IOException ex) {
            System.err.println(ex.getMessage());
        }
        catch(DeploymentException ex) {
            System.err.println(ex.getMessage());
        }
        catch(URISyntaxException ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcTimedout ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcClientException ex) {
            ex.printCauseTrace();
        }
        catch(WebSocketException ex) {
            ex.printCauseTrace();
        }
        finally {
            try {
                if(client!=null) client.disconnect();
            }
            catch(IOException ex) {}
        }
    }
}
