package com.companyname.hello.server.impl;
/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */

import com.companyname.hello.common.HelloEndpointServerInterface_V1;
import com.companyname.hello.common.ServerEndPointInterface;
import com.companyname.hello.common.beans.HelloException;
import com.companyname.hello.server.HelloServerRandomImplementation;
import com.companyname.hello.server.HelloServerStub_V1;

import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import java.sql.Date;
import java.util.Map;

public class HelloEndpointServerSessionImpl_V1 extends HelloServerRandomImplementation implements HelloEndpointServerInterface_V1, ServerEndPointInterface {
    protected Map<String, Object> userProperties = null;
    protected HelloServerStub_V1 serverStub = null;
    protected Session session__ = null;

    public HelloEndpointServerSessionImpl_V1(HelloServerStub_V1 serverStub) {
        this.serverStub = serverStub;
    }

    /**
     * Implementation WebSocket endpoint routines.
     */
    public void onOpen(Session session, EndpointConfig endpointConfig) {
        this.session__ = session;
        this.userProperties = this.session__.getUserProperties();
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.session__ = null;
    }

    public void onError(Session session, java.lang.Throwable thr) {
        System.out.println(thr.getMessage());
        thr.printStackTrace();
    }

    protected HelloServerStub_V1 createServerStub() {
        return new HelloServerStub_V1(this.session__);
    }


    /**
     * Implement your methods here!
     */
    /**
     * syncmethod String[] sendHello( [in] String content, [in] Boolean throwSomething ) throws HelloException {};
     */
    public String[] helloMethod(String content, Boolean throwSomething) throws HelloException {
        System.out.println("Inside helloMethod method");
        if (throwSomething != null && throwSomething.booleanValue())
            throw new HelloException("Hello");
        return new String[]{"Hello", "Hello", "Hello", "Hello"};
    }

    public String[] helloMethod2(String content, Boolean throwSomething) throws HelloException {
        System.out.println("Inside helloMethod2 method");
        if (throwSomething != null && throwSomething.booleanValue())
            throw new HelloException("World");
        return new String[]{"World", "World", "World", "World"};
    }

    public void helloAsyncMethod(Integer arg) {
        System.out.println("Inside helloAsyncMethod method");
        serverStub.callBack("HelloWorld");
    }

    public Date helloDateMethod(Date dateArg) throws HelloException {
        System.out.println("Inside helloDateMethod method");
        if (dateArg == null || !dateArg.toString().equals("2015-02-13"))
            throw new HelloException("Date");
        return Date.valueOf("2014-12-23");
    }
}
