package com.companyname.lists.client.impl;

import com.companyname.lists.client.*;
import com.companyname.lists.common.ListsLogger;
import com.companyname.lists.common.beans.ListsException;
import com.companyname.lists.common.enums.DoSomething;
import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.webrpc.exception.WebRpcTimedout;
import com.objectriver.runtime.webrpc.exception.WebRpcClientException;
import com.objectriver.runtime.webrpc.exception.beans.WebSocketException;
import com.objectriver.runtime.webrpc.properties.WebRpcProperties;

import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class ListsMain {
    public static void main(String[] args) {
        //ListsLogger.clogger.setLevel(Level.FINE);
        //ListsLogger.mlogger.setLevel(Level.FINER);
        ListsClient client = null;
        try {
            Properties props = WebRpcProperties.getProperties("webrpc.properties");
            String url = "ws://"+props.getProperty("webrpc.host")+":"+props.getProperty("webrpc.port")
                +"/ListsWebApp" // RootWebServer - This may depend on web server deployment, and type of web server
                +'/' + "Test"   // RootContext
                +'/' + "Lists" // If URI contains WebSocket Path templates you may want to modify this.
                ;
            client = ListsClient.connect(url);
            /**
             * insert client code here
             */
            /**
             * Test1: SyncMethod List<Integer> returnList([in] int size) raises ListsException;
             */
            List<Integer> integers = new LinkedList<Integer>();
            int size = 3;
            try {
                integers = client.returnList(size);
                for (Integer integer : integers) {
                    if (integer.intValue() != 6) throw new ListsException("integer.intValue() != 6");
                }
            } catch (ListsException ex) {
                Assert.fail();
            }
            /**
             * Test2: SyncMethod void inoutList([inout] List<String> listOfString)  raises ListsException;
             */
            DoSomething[] somethings = {DoSomething.Fred_instance, DoSomething.Barney_instance, DoSomething.Wilma_instance, DoSomething.Betty_instance};

            List<String> listOfString = new LinkedList<String>();
            listOfString.add(somethings[0].toString());
            listOfString.add(somethings[1].toString());
            listOfString.add(somethings[2].toString());
            listOfString.add(somethings[3].toString());
            try {
                client.inoutList(listOfString);
                //verify the changed value of listOfString
                if (!listOfString.get(0).equals(somethings[3].toString()))
                    throw new ListsException("!listOfString.get(0).equals(somethings[3].toString())");
                if (!listOfString.get(1).equals(somethings[2].toString()))
                    throw new ListsException("!listOfString.get(1).equals(somethings[3].toString())");
                if (!listOfString.get(2).equals(somethings[1].toString()))
                    throw new ListsException("!listOfString.get(2).equals(somethings[3].toString())");
                if (!listOfString.get(3).equals(somethings[0].toString()))
                    throw new ListsException("!listOfString.get(3).equals(somethings[3].toString())");
                System.out.println("listOfString:");
                for (String str : listOfString) {
                    System.out.println(str);
                }
            } catch (ListsException ex) {
                Assert.fail();
            }
            /**
             * Test3: SyncMethod void outList([out] List<String> listOfString)  raises ListsException;
             */
            List<String> outListOfString = new LinkedList<String>();
            try {
                client.outList(outListOfString);
                System.out.println("outListOfString:");
                for (String str : outListOfString) {
                    System.out.println(str);
                }
            } catch (ListsException ex) {
                Assert.fail();
            }
            /**
             * Test4:  SyncMethod void enumList([in] List<DoSomething> inlist, [inout]  List<DoSomething> inoutlist, [out] List<DoSomething> outlist )  raises ListsException;
             */
            List<DoSomething> inlist = new LinkedList<DoSomething>();
            inlist.add(somethings[0]);
            inlist.add(somethings[1]);
            inlist.add(somethings[2]);
            inlist.add(somethings[3]);

            List<DoSomething> inoutlist = new LinkedList<DoSomething>();
            inoutlist.add(somethings[0]);
            inoutlist.add(somethings[1]);
            inoutlist.add(somethings[2]);
            inoutlist.add(somethings[3]);

            List<DoSomething> outlist = new LinkedList<DoSomething>();

            try {
                client.enumList(inlist, inoutlist, outlist);
                //verify the changed value of inoutlist
                if (inoutlist.get(0) != somethings[3]) Assert.fail();
                if (inoutlist.get(1) != somethings[2]) Assert.fail();
                if (inoutlist.get(2) != somethings[1]) Assert.fail();
                if (inoutlist.get(3) != somethings[0]) Assert.fail();
                System.out.println("inoutlist:");
                for (DoSomething doSomething : inoutlist) {
                    System.out.println(doSomething);
                }

                //verify the changed value of outlist
                if (outlist.get(0) != somethings[0]) Assert.fail();
                if (outlist.get(1) != somethings[0]) Assert.fail();
                if (outlist.get(2) != somethings[0]) Assert.fail();
                if (outlist.get(3) != somethings[0]) Assert.fail();
                System.out.println("outlist:");
                for (DoSomething doSomething : outlist) {
                    System.out.println(doSomething);
                }
            } catch (ListsException ex) {
                ex.printCauseTrace();
                Assert.fail();
            }
        }
        catch(IOException ex) {
            System.err.println(ex.getMessage());
        }
        catch(DeploymentException ex) {
            System.err.println(ex.getMessage());
        }
        catch(URISyntaxException ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcTimedout ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcClientException ex) {
            ex.printCauseTrace();
        }
        catch(WebSocketException ex) {
            ex.printCauseTrace();
        }
        finally {
            try {
                if(client!=null) client.disconnect();
            }
            catch(IOException ex) {}
        }
    }
}
