package com.companyname.lists.server.impl;
/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */

import com.companyname.lists.common.*;
import com.companyname.lists.server.*;
import com.companyname.lists.common.beans.*;
import com.companyname.lists.common.enums.*;

import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import java.sql.*;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.HashSet;
import java.util.logging.Level;

public class ListsIfaceServerSessionImpl_V1 extends ListsServerRandomImplementation implements ListsIfaceServerInterface_V1,ServerEndPointInterface {
    protected Map<String, Object> userProperties = null;
    protected ListsServerStub_V1 serverStub = null;
    protected Session session__ = null;
    public ListsIfaceServerSessionImpl_V1(ListsServerStub_V1 serverStub) {
        this.serverStub = serverStub;
    }
    /**
     * Implementation WebSocket endpoint routines.
     */
    public void onOpen(Session session, EndpointConfig endpointConfig) {
        this.session__ = session;
        this.userProperties = this.session__.getUserProperties();
        ListsLogger.slogger.setLevel(Level.FINE);
        //ListsLogger.mlogger.setLevel(Level.FINER);
    }
    public void onClose(Session session, CloseReason closeReason) {
        this.session__ = null;
    }
    public void onError(Session session, java.lang.Throwable thr) {
        System.out.println(thr.getMessage());
        thr.printStackTrace();
    }


    /**
     * Implement your methods here!
     */
    /**
     *
     * syncmethod List<Integer> returnList( [in] Integer size ) throws ListsException {};
     *
     */
    public List<Integer> returnList( Integer size) throws ListsException {
        System.out.println("Inside returnList method");
        if(size != 3) throw new ListsException("size != 3");
        List<Integer> integers = new LinkedList<Integer>();
        for(int i = 0; i < size; i++){
            integers.add(new Integer(6));
        }
        return        integers;
    }
    /**
     *
     * syncmethod void inoutList( [inout] List<String> listOfString ) throws ListsException {};
     *
     */
    public void inoutList( List<String> listOfString) throws ListsException {
        System.out.println("Inside inoutList method");
        DoSomething[] somethings = {DoSomething.Fred_instance, DoSomething.Barney_instance, DoSomething.Wilma_instance, DoSomething.Betty_instance};
        //verify the listOfString
        if(!listOfString.get(0).equals(somethings[0].toString())) throw new ListsException("!listOfString.get(0).equals(somethings[0].toString())");
        if(!listOfString.get(1).equals(somethings[1].toString())) throw new ListsException("!listOfString.get(1).equals(somethings[1].toString())");
        if(!listOfString.get(2).equals(somethings[2].toString())) throw new ListsException("!listOfString.get(2).equals(somethings[2].toString())");
        if(!listOfString.get(3).equals(somethings[3].toString())) throw new ListsException("!listOfString.get(3).equals(somethings[3].toString())");
        //change the listOfString
        listOfString.clear();
        listOfString.add(somethings[3].toString());
        listOfString.add(somethings[2].toString());
        listOfString.add(somethings[1].toString());
        listOfString.add(somethings[0].toString());
//        super.inoutList( listOfString );
    }
    /**
     *
     * syncmethod void outList( [out] List<String> listOfString ) throws ListsException {};
     *
     */
    public void outList( List<String> listOfString) throws ListsException {
        System.out.println("Inside outList method");
        DoSomething[] somethings = {DoSomething.Fred_instance, DoSomething.Barney_instance, DoSomething.Wilma_instance, DoSomething.Betty_instance};

        listOfString.add(somethings[0].toString());
        listOfString.add(somethings[1].toString());
        listOfString.add(somethings[2].toString());
        listOfString.add(somethings[3].toString());

//        super.outList( listOfString );
    }
    /**
     *
     * syncmethod void enumList( [in] List<DoSomething> inlist, [inout] List<DoSomething> inoutlist, [out] List<DoSomething> outlist ) throws ListsException {};
     *
     */
    public void enumList( List<DoSomething> inlist, List<DoSomething> inoutlist, List<DoSomething> outlist) throws ListsException {
        System.out.println("Inside enumList method");
        DoSomething[] somethings = {DoSomething.Fred_instance, DoSomething.Barney_instance, DoSomething.Wilma_instance, DoSomething.Betty_instance};
        //verify the inlist
        if(inlist.get(0)!=somethings[0]) throw new ListsException("inlist.get(0)!=somethings[0]");
        if(inlist.get(1)!=somethings[1]) throw new ListsException("(inlist.get(1)!=somethings[1]");
        if(inlist.get(2)!=somethings[2]) throw new ListsException("inlist.get(2)!=somethings[2]");
        if(inlist.get(3)!=somethings[3]) throw new ListsException("inlist.get(3)!=somethings[3]");

        //verify the inoutlist
        if(inoutlist.get(0)!=somethings[0]) throw new ListsException("(inoutlist.get(0)!=somethings[0]");
        if(inoutlist.get(1)!=somethings[1]) throw new ListsException("inoutlist.get(1)!=somethings[1]");
        if(inoutlist.get(2)!=somethings[2]) throw new ListsException("inoutlist.get(2)!=somethings[2]");
        if(inoutlist.get(3)!=somethings[3]) throw new ListsException("inoutlist.get(3)!=somethings[3]");
        //change the inoutlist
        inoutlist.clear();
        inoutlist.add(somethings[3]);
        inoutlist.add(somethings[2]);
        inoutlist.add(somethings[1]);
        inoutlist.add(somethings[0]);

        //initialize the outlist
        outlist.add(somethings[0]);
        outlist.add(somethings[0]);
        outlist.add(somethings[0]);
        outlist.add(somethings[0]);

//        super.enumList( inlist, inoutlist, outlist );
    }
}
