package com.companyname.returnbinary.client.impl;

import com.companyname.returnbinary.client.*;
import com.companyname.returnbinary.common.ReturnBinaryLogger;
import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.webrpc.exception.WebRpcTimedout;
import com.objectriver.runtime.webrpc.exception.WebRpcClientException;
import com.objectriver.runtime.webrpc.exception.beans.WebSocketException;
import com.objectriver.runtime.webrpc.properties.WebRpcProperties;

import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.WebSocketContainer;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.logging.Level;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class ReturnBinaryMain {
    public static void main(String[] args) {
        //ReturnBinaryLogger.clogger.setLevel(Level.FINE);
        //ReturnBinaryLogger.mlogger.setLevel(Level.FINER);
        ReturnBinaryClient client = null;
        try {
            Properties props = WebRpcProperties.getProperties("webrpc.properties");
            String url = "ws://"+props.getProperty("webrpc.host")+":"+props.getProperty("webrpc.port")
                +"/ReturnBinaryWebApp" // RootWebServer - This may depend on web server deployment, and type of web server
                +'/' + "Test"   // RootContext
                +'/' + "ReturnBinary" // If URI contains WebSocket Path templates you may want to modify this.
                ;
            client = ReturnBinaryClient.connect(url);
            /**
             * insert client code here
             */
            InputStream result = (InputStream) client.method1(1234);
            Assert.assertTrue(result != null);
            DataInputStream dis = new DataInputStream(result);
            int answer = 0;
            try {
                answer = dis.readInt();
            } catch (IOException e) {
                e.printStackTrace();
            }
            Assert.assertTrue(answer == 1234);
            System.out.println("answer: " + answer);
            try {
                client.disconnect();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch(IOException ex) {
            System.err.println(ex.getMessage());
        }
        catch(DeploymentException ex) {
            System.err.println(ex.getMessage());
        }
        catch(URISyntaxException ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcTimedout ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcClientException ex) {
            ex.printCauseTrace();
        }
        catch(WebSocketException ex) {
            ex.printCauseTrace();
        }
        finally {
            try {
                if(client!=null) client.disconnect();
            }
            catch(IOException ex) {}
        }
    }
}
