package com.companyname.sendreply.client.impl;

import com.companyname.sendreply.client.*;
import com.companyname.sendreply.common.SendReplyLogger;
import com.companyname.sendreply.common.beans.SendReplyException;
import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.webrpc.exception.WebRpcTimedout;
import com.objectriver.runtime.webrpc.exception.WebRpcClientException;
import com.objectriver.runtime.webrpc.exception.beans.WebSocketException;
import com.objectriver.runtime.webrpc.properties.WebRpcProperties;

import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.logging.Level;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class SendReplyMain {
    public static void main(String[] args) {
        //SendReplyLogger.clogger.setLevel(Level.FINE);
        //SendReplyLogger.mlogger.setLevel(Level.FINER);
        SendReplyClient client = null;
        try {
            Properties props = WebRpcProperties.getProperties("webrpc.properties");
            String url = "ws://"+props.getProperty("webrpc.host")+":"+props.getProperty("webrpc.port")
                +"/SendReplyWebApp" // RootWebServer - This may depend on web server deployment, and type of web server
                +'/' + "Test"   // RootContext
                +'/' + "SendReply" // If URI contains WebSocket Path templates you may want to modify this.
                ;
            client = SendReplyClient.connect(url);
            /**
             * insert client code here
             */
            /**
             * Test1: syncreplymethod void method1( [out] String[] arg3 ) throws SendReplyException {};
             */
            String[] arg3 = new String[100];
            try {
                client.method1(arg3);
            } catch (SendReplyException ex) {
                Assert.fail();
            }
            if (!arg3[0].equals("aaa")) throw new SendReplyException("!arg3[0].equals(\"aaa\")");
            if (!arg3[1].equals("bbb")) throw new SendReplyException("!arg3[1].equals(\"bbb\")");
            if (!arg3[2].equals("ccc")) throw new SendReplyException("!arg3[2].equals(\"ccc\")");
            /**
             * Test2: syncreplymethod String[] method2( [out] Integer[] arg3 ) throws SendReplyException {};
             */
            Integer[] arg5 = new Integer[100];
            String[] arg6 = new String[1];
            try {
                arg6 = client.method2(arg5);
            } catch (SendReplyException ex) {
                Assert.fail();
            }
            for(int i = 0; i <100; i++){
                if(arg5[i] != i+1) throw new SendReplyException("arg5[i] != (i+1)");
            }
            if(!arg6[0].equals("method2 can work")) throw new SendReplyException("!arg6[0].equals(\"method2 can work\")");
            /**
             * Test3: syncreplymethod Long handleexception () throws SendReplyException {};
             */
            Long result = null;
            try{
                result = client.handleexception();
            }catch (SendReplyException ex){
                Assert.fail();
            }
            System.out.println("result: " + result);
        }
        catch(IOException ex) {
            System.err.println(ex.getMessage());
        }
        catch(DeploymentException ex) {
            System.err.println(ex.getMessage());
        }
        catch(URISyntaxException ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcTimedout ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcClientException ex) {
            ex.printCauseTrace();
        }
        catch(WebSocketException ex) {
            ex.printCauseTrace();
        }
        finally {
            try {
                if(client!=null) client.disconnect();
            }
            catch(IOException ex) {}
        }
    }
}
