package com.companyname.simple.client.impl;

import com.companyname.simple.client.*;
import com.companyname.simple.common.SimpleLogger;
import com.companyname.simple.common.beans.SimpleBean;
import com.companyname.simple.common.beans.SimpleBeanFactory;
import com.companyname.simple.common.beans.SimpleException;
import com.companyname.simple.common.enums.SimpleEnumeration;
import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.webrpc.exception.WebRpcTimedout;
import com.objectriver.runtime.webrpc.exception.WebRpcClientException;
import com.objectriver.runtime.webrpc.exception.beans.WebSocketException;
import com.objectriver.runtime.webrpc.properties.WebRpcProperties;

import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class SimpleMain {
    public static void main(String[] args) {
        //SimpleLogger.clogger.setLevel(Level.FINE);
        //SimpleLogger.mlogger.setLevel(Level.FINER);
        SimpleClient client = null;
        try {
            Properties props = WebRpcProperties.getProperties("webrpc.properties");
            String url = "ws://"+props.getProperty("webrpc.host")+":"+props.getProperty("webrpc.port")
                +"/SimpleWebApp" // RootWebServer - This may depend on web server deployment, and type of web server
                +'/' + "Test"   // RootContext
                +'/' + "Simple" // If URI contains WebSocket Path templates you may want to modify this.
                ;
            client = SimpleClient.connect(url);

            /**
             * insert client code here
             */
            SimpleEnumeration[] colors = {SimpleEnumeration.Red_instance, SimpleEnumeration.White_instance, SimpleEnumeration.Blue_instance};
            Integer[] expectedReturnVals = null;
            SimpleBean bean = SimpleBeanFactory.valueOf(colors);
            boolean expectedException = true;
            try {
                expectedReturnVals = client.simpleMethod(bean, false);
                System.out.println("expectedReturnVals[0]: " + expectedReturnVals[0]);
                System.out.println("expectedReturnVals[1]: " + expectedReturnVals[1]);
                System.out.println("expectedReturnVals[2]: " + expectedReturnVals[2]);
                if (!(expectedReturnVals[0].intValue() == 1 && expectedReturnVals[1].intValue() == 2 && expectedReturnVals[2].intValue() == 3)) {
                    Assert.fail();
                }
            } catch (SimpleException ex) {
                expectedException = false;
            }
            Assert.assertTrue(expectedException);

            client.roundTrip("Hello ObjectRiver!!!");


            List<SimpleEnumeration> enums = new LinkedList<SimpleEnumeration>();
            enums.add(SimpleEnumeration.Red_instance);
            enums.add(SimpleEnumeration.White_instance);
            enums.add(SimpleEnumeration.Blue_instance);
            try {
                client.SimpleList(enums);
                for (SimpleEnumeration mSimpleEnumeration : enums) {
                    System.out.println(mSimpleEnumeration.getEnumeration().name());
                }
                if (enums.get(0) != SimpleEnumeration.Blue_instance)
                    throw new SimpleException(SimpleEnumeration.Blue_instance, new RuntimeException("expectedEnums.get(0)!=SimpleEnumeration.Blue_instance"));
                if (enums.get(1) != SimpleEnumeration.Blue_instance)
                    throw new SimpleException(SimpleEnumeration.Blue_instance, new RuntimeException("expectedEnums.get(1)!=SimpleEnumeration.Blue_instance"));
                if (enums.get(2) != SimpleEnumeration.Blue_instance)
                    throw new SimpleException(SimpleEnumeration.Blue_instance, new RuntimeException("expectedEnums.get(2)!=SimpleEnumeration.Blue_instance"));
            } catch (SimpleException ex) {
                Assert.fail();
            }

        }
        catch(IOException ex) {
            System.err.println(ex.getMessage());
        }
        catch(DeploymentException ex) {
            System.err.println(ex.getMessage());
        }
        catch(URISyntaxException ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcTimedout ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcClientException ex) {
            ex.printCauseTrace();
        }
        catch(WebSocketException ex) {
            ex.printCauseTrace();
        }
        finally {
            try {
                if(client!=null) client.disconnect();
            }
            catch(IOException ex) {}
        }
    }
}
