package com.companyname.simple.server.impl;
/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */

import com.companyname.simple.common.*;
import com.companyname.simple.server.*;
import com.companyname.simple.common.beans.*;
import com.companyname.simple.common.enums.*;

import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import java.sql.*;
import java.util.List;
import java.util.Map;
import java.util.HashSet;
import java.util.logging.Level;

public class SimpleInterfaceServerSessionImpl_V1 extends SimpleServerRandomImplementation implements SimpleInterfaceServerInterface_V1, ServerEndPointInterface {
    protected Map<String, Object> userProperties = null;
    protected SimpleServerStub_V1 serverStub = null;
    protected Session session__ = null;

    public SimpleInterfaceServerSessionImpl_V1(SimpleServerStub_V1 serverStub) {
        this.serverStub = serverStub;
    }

    /**
     * Implementation WebSocket endpoint routines.
     */
    public void onOpen(Session session, EndpointConfig endpointConfig) {
        this.session__ = session;
        this.userProperties = this.session__.getUserProperties();
        SimpleLogger.slogger.setLevel(Level.FINE);
        //SimpleLogger.mlogger.setLevel(Level.FINER);
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.session__ = null;
    }

    public void onError(Session session, java.lang.Throwable thr) {
        System.out.println(thr.getMessage());
        thr.printStackTrace();
    }


    /**
     * Implement your methods here!
     */
    /**
     * syncmethod Integer[] simpleMethod( [in] SimpleBean bean, [in] Boolean throwException ) throws SimpleException {};
     */
    public Integer[] simpleMethod(SimpleBean bean, Boolean throwException) throws SimpleException {
        System.out.println("Inside simpleMethod method");
        SimpleEnumeration[] expectedColors = bean.getColors();
        // verify colors
        if (expectedColors[0] != SimpleEnumeration.Red_instance)
            throw new SimpleException(SimpleEnumeration.Red_instance, new RuntimeException("expectedColors[0]!=SimpleEnumeration.Red_instance"));
        if (expectedColors[1] != SimpleEnumeration.White_instance)
            throw new SimpleException(SimpleEnumeration.White_instance, new RuntimeException("expectedColors[1]!=SimpleEnumeration.White_instance"));
        if (expectedColors[2] != SimpleEnumeration.Blue_instance)
            throw new SimpleException(SimpleEnumeration.Blue_instance, new RuntimeException("expectedColors[2]!=SimpleEnumeration.Blue_instance"));

        if (throwException) throw new SimpleException(SimpleEnumeration.Red_instance);
        return new Integer[]{1, 2, 3};
    }

    /**
     * syncmethod Boolean SimpleList( [inout] List<SimpleEnumeration> enums ) throws SimpleException {};
     */
    public Boolean SimpleList(List<SimpleEnumeration> enums) throws SimpleException {
        System.out.println("Inside SimpleList method");
        // verify colors
        if (enums.get(0) != SimpleEnumeration.Red_instance)
            throw new SimpleException(SimpleEnumeration.Red_instance, new RuntimeException("expectedEnums.get(0)!=SimpleEnumeration.Red_instance"));
        if (enums.get(1) != SimpleEnumeration.White_instance)
            throw new SimpleException(SimpleEnumeration.White_instance, new RuntimeException("expectedEnums.get(1)!=SimpleEnumeration.White_instance"));
        if (enums.get(2) != SimpleEnumeration.Blue_instance)
            throw new SimpleException(SimpleEnumeration.Blue_instance, new RuntimeException("expectedEnums.get(2)!=SimpleEnumeration.Blue_instance"));
        // Change colors
        enums.clear();
        enums.add(SimpleEnumeration.Blue_instance);
        enums.add(SimpleEnumeration.Blue_instance);
        enums.add(SimpleEnumeration.Blue_instance);
        return true;
    }

    /**
     * asyncmethod void roundTrip( [in] String hello ) throws SimpleException {};
     */
    public void roundTrip(String hello) throws SimpleException {
        System.out.println("Inside roundTrip method");
        System.out.println("roundTrip:  " + hello);
        if (!hello.equals("Hello ObjectRiver!!!")) throw new SimpleException("roundTrip has errors");
        serverStub.sayHello("Hello YouTube!");
    }
}
