package com.companyname.syncwait.client.impl;

import com.companyname.syncwait.client.*;
import com.companyname.syncwait.common.SyncWaitLogger;
import com.companyname.syncwait.common.beans.SyncWaitException;
import com.companyname.syncwait.common.documents.WaitMethodResponseDocument_V1;
import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.webrpc.exception.WebRpcTimedout;
import com.objectriver.runtime.webrpc.exception.WebRpcClientException;
import com.objectriver.runtime.webrpc.exception.beans.WebSocketException;
import com.objectriver.runtime.webrpc.properties.WebRpcProperties;

import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.logging.Level;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class SyncWaitMain {
    public static void main(String[] args) {
        //SyncWaitLogger.clogger.setLevel(Level.FINE);
        //SyncWaitLogger.mlogger.setLevel(Level.FINER);
        SyncWaitClient client = null;
        try {
            Properties props = WebRpcProperties.getProperties("webrpc.properties");
            String url = "ws://"+props.getProperty("webrpc.host")+":"+props.getProperty("webrpc.port")
                +"/SyncWaitWebApp" // RootWebServer - This may depend on web server deployment, and type of web server
                +'/' + "Test"   // RootContext
                +'/' + "SyncWait" // If URI contains WebSocket Path templates you may want to modify this.
                ;
            client = SyncWaitClient.connect(url);
            /**
             * insert client code here
             */
            String[] array = {"aaa", "bbb", "ccc"};
            System.out.println("[in]array: " + array[0] + array[1] + array[2]);
            try {
                client.waitMethod(array);
                WaitMethodResponseDocument_V1 response = client.waitMethod_wait();
                array = response.getArray();
                if (!array[0].equals("ddd")) throw new SyncWaitException("!array[0].equals(\"ddd\")");
                if (!array[1].equals("eee")) throw new SyncWaitException("!array[1].equals(\"eee\")");
                if (!array[2].equals("fff")) throw new SyncWaitException("!array[2].equals(\"fff\")");
                System.out.println("[out]array: " + array[0] + array[1] + array[2]);
            } catch (SyncWaitException ex) {
                Assert.fail();
            }
        }
        catch(IOException ex) {
            System.err.println(ex.getMessage());
        }
        catch(DeploymentException ex) {
            System.err.println(ex.getMessage());
        }
        catch(URISyntaxException ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcTimedout ex) {
            System.err.println(ex.getMessage());
        }
        catch(WebRpcClientException ex) {
            ex.printCauseTrace();
        }
        catch(WebSocketException ex) {
            ex.printCauseTrace();
        }
        finally {
            try {
                if(client!=null) client.disconnect();
            }
            catch(IOException ex) {}
        }
    }
}
