package com.objectriver.runtime.webrpc.exception.beans;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2014, ObjectRiver(tm). All rights reserved.
 */
public class WebRpcExceptionCause {
    protected Throwable cause=null;
    protected String type = null;
    protected String message = null;
    protected WebRpcExceptionStackLocation location=null;
    public WebRpcExceptionCause() { //decode
    }
    public WebRpcExceptionCause(Throwable cause) {
        this.cause = cause;
        if(cause!=null) {
            this.type = cause.getClass().getSimpleName();
            this.message = cause.getMessage();
            StackTraceElement[] steArray = cause.getStackTrace();
            if(steArray!=null && steArray.length!=0) {
                this.location = new WebRpcExceptionStackLocation(steArray[0]);
            }
        }
    }
    public String getMessage() {
        return message;
    }
    public void setMessage(String message) {
        this.message = message;
    }
    public String getType() {
        return type;
    }
    public void setType(String type) {
        this.type = type;
    }

    public Throwable getCause() {
        return cause;
    }
    public WebRpcExceptionStackLocation getLocation() {
        return location;
    }
    public void setLocation(WebRpcExceptionStackLocation location) {
        this.location = location;
    }
    public String toString() {
        String message = (this.message!=null) ? this.getMessage() : " ";
        return this.type + " message:" + "\"" + message + "\" "+ ((location!=null) ? location.toString() : "");
    }
}
