package com.objectriver.runtime.webrpc.exception.beans;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2014, ObjectRiver(tm). All rights reserved.
 */
public class WebRpcExceptionStackLocation {
    protected String declaringClass;
    protected String methodName;
    protected String fileName;
    protected int lineNumber;
    public WebRpcExceptionStackLocation(StackTraceElement ste) {
        if(ste==null) {
            declaringClass = "Unknown";
            methodName = "Unknown";
            fileName = "Unknown";
            lineNumber = 0;
        }
        else {
            declaringClass = ste.getClassName();
//            declaringClass = declaringClass.substring(declaringClass.lastIndexOf(".")+1);
            methodName = ste.getMethodName();
            fileName = ste.getFileName();
            lineNumber = ste.getLineNumber();
        }
    }

    public String getDeclaringClass() {
        return declaringClass;
    }

    public void setDeclaringClass(String declaringClass) {
        this.declaringClass = declaringClass;
    }

    public String getMethodName() {
        return methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getLineNumber() {
        return lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("method=").append(declaringClass).append(':');
        buff.append(methodName);
        buff.append('(').append(fileName).append(' ');
        buff.append(":").append(lineNumber).append(')');
        return buff.toString();
    }
}
