package com.objectriver.runtime.webrpc.exception.beans;
/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WebSocketException extends WebSocketException_V1 {
	public WebSocketException(){}
    public WebSocketException(String message){
        super(message);
        populateCauses(this);
    }
    public WebSocketException(Throwable cause) {
        super(cause);
        populateCauses(this);
    }
    public WebSocketException(String message,Throwable cause){
        super(message,cause);
        populateCauses(this);
    }
    public List<String> printCauseTrace() {
	    List<String> console = new ArrayList<>();
        Iterator<WebRpcExceptionCause> iter =  this.iterator();
        boolean first = true;
        while(iter.hasNext()) {
            WebRpcExceptionCause cause = iter.next();
            if(first) {
                System.err.printf("Exception %s\n",cause.toString());
                console.add("Exception " + cause.toString());
            }
            else {
                System.err.printf("Caused by %s\n",cause.toString());
                console.add("Caused by " + cause.toString());
            }
            first=false;
        }
        return console;
    }
}
