package com.objectriver.runtime.webrpc.exception.beans;

import com.objectriver.runtime.util.ArrayIterator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2014, ObjectRiver(tm). All rights reserved.
 */
public class WebSocketException_V1 extends RuntimeException {
    public WebSocketException_V1() {
        super();
    }
    public WebSocketException_V1(String message) {
        super(message);
        setMessage(message);
    }
    public WebSocketException_V1(Throwable cause) {
        super(cause);
    }
    public WebSocketException_V1( String message, Throwable cause ) {
           super(message,cause);
            setMessage(message);
    }
	public WebSocketException_V1( String message, WebRpcExceptionCause[]  causes, Throwable cause ) {
        super(message,cause);
        this.causes = causes;
    }
	public WebSocketException_V1( String message, WebRpcExceptionCause[] causes ) {
        super(message);
        this.causes = causes;
    }

   /**
    * Properties
    */
    protected String message = null;
    public String getMessage() { return message; }
    public void setMessage(String message) { this.message = message; }

    protected WebRpcExceptionCause[] causes;
    public WebRpcExceptionCause[] getCauses() {
        return causes;
    }
    public void setCauses(WebRpcExceptionCause[] causes) {
        this.causes = causes;
    }

    protected void populateCauses(Throwable cause) {
        HashSet<Throwable> set = new HashSet<Throwable>();
        ArrayList<WebRpcExceptionCause> tmpList = new ArrayList<WebRpcExceptionCause>();
        while(cause!=null && !set.contains(cause)) {
            WebRpcExceptionCause c = new WebRpcExceptionCause(cause);
            tmpList.add(c);
            set.add(cause);
            cause = cause.getCause();
        }
        causes = tmpList.toArray(new WebRpcExceptionCause[]{});
    }
    public Iterator<WebRpcExceptionCause> iterator() {
        return new ArrayIterator(causes);
    }
}
