package com.objectriver.runtime.webrpc.exception.beans.json;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.exception.beans.WebRpcExceptionCause;
import com.objectriver.runtime.webrpc.exception.beans.WebRpcExceptionStackLocation;
import com.objectriver.runtime.webrpc.json.*;
import com.objectriver.runtime.webrpc.json.marshals.*;

import javax.json.stream.JsonParsingException;
import java.sql.*;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class JsonWebRpcExceptionCause extends JsonMarshal {
    public JsonWebRpcExceptionCause() {
    }

    public static JsonWebRpcExceptionCause instance;
    static {
        instance = new JsonWebRpcExceptionCause();
    }
    public boolean execute(JSON jsons, JsonThing thing1)  throws WebRpcMarshallingException {
        WebRpcExceptionCause request_response = (WebRpcExceptionCause) thing1.getThing();
        JsonThing thing2 = new JsonThing();
            if(request_response==null) {
                request_response = new WebRpcExceptionCause();
                thing1.setThing(request_response);
            }
            try {
                /**
                 * String message
                 **/
                thing2.setJvalue("message", request_response.getMessage());
                 if(!json_string.instance.execute(jsons, thing2)) {
                     return false;
                 }
                 request_response.setMessage((String)thing2.getThing());
                 jsons.separator();
                /**
                 * String type
                 **/
                thing2.setJvalue("type", request_response.getType());
                 if(!json_string.instance.execute(jsons, thing2)) {
                     return false;
                 }
                 request_response.setType((String)thing2.getThing());
                 jsons.separator();
                 /**
                 * WebRpcExceptionStackLocation location
                 **/
                thing2.setJvalue("location",request_response.getLocation());
                jsons.startObject("location");
                if(!json_pointer(jsons, thing2, JsonWebRpcExceptionStackLocation.instance)) {
                    return false;
                }
                jsons.endObject();
                request_response.setLocation((WebRpcExceptionStackLocation)thing2.getThing());
            }
            catch (JsonParsingException ex) {
                throw new WebRpcMarshallingException("JsonWebRpcExceptionCause",ex);
            }
            catch (WebRpcMarshallingException ex) {
                throw new WebRpcMarshallingException("JsonWebRpcExceptionCause",ex);
            }
            return true;

    }
    public Class getClazz() {
        return WebRpcExceptionCause.class;
    }
    public boolean isBean() {
        return true;
    }
}
