package com.objectriver.runtime.webrpc.exception.beans.json;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.exception.beans.WebRpcExceptionStackLocation;
import com.objectriver.runtime.webrpc.json.*;
import com.objectriver.runtime.webrpc.json.marshals.*;

import javax.json.stream.JsonParsingException;
import java.sql.*;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class JsonWebRpcExceptionStackLocation extends JsonMarshal {
    public static JsonWebRpcExceptionStackLocation instance;
    static {
        instance = new JsonWebRpcExceptionStackLocation();
    }
    public boolean execute(JSON jsons, JsonThing thing1)  throws WebRpcMarshallingException {
        WebRpcExceptionStackLocation request_response = (WebRpcExceptionStackLocation) thing1.getThing();
        JsonThing thing2 = new JsonThing();
            if(request_response==null) {
                request_response = new WebRpcExceptionStackLocation(null); //todo:
                thing1.setThing(request_response);
            }
            try {
                 /**
                 * String declaringClass
                 **/
                thing2.setJvalue("declaringClass",request_response.getDeclaringClass());
                if(!json_string.instance.execute(jsons, thing2)) {
                    return false;
                }
                request_response.setDeclaringClass((String)thing2.getThing());
                jsons.separator();

                 /**
                 * String methodName
                 **/
                thing2.setJvalue("methodName",request_response.getMethodName());
                if(!json_string.instance.execute(jsons, thing2)) {
                    return false;
                }
                request_response.setMethodName((String)thing2.getThing());
                jsons.separator();

                 /**
                 * String fileName
                 **/
                thing2.setJvalue("fileName",request_response.getFileName());
                if(!json_string.instance.execute(jsons, thing2)) {
                    return false;
                }
                request_response.setFileName((String)thing2.getThing());
                jsons.separator();

                 /**
                 * Integer lineNumber
                 **/
                thing2.setJvalue("lineNumber",request_response.getLineNumber());
                if(!json_int.instance.execute(jsons, thing2)) {
                    return false;
                }
                request_response.setLineNumber((Integer)thing2.getThing());
            }
            catch (JsonParsingException ex) {
                throw new WebRpcMarshallingException("JsonWebRpcExceptionStackLocation",ex);
            }
            catch (WebRpcMarshallingException ex) {
                throw new WebRpcMarshallingException("JsonWebRpcExceptionStackLocation",ex);
            }
            return true;

    }
    public Class getClazz() {
        return WebRpcExceptionStackLocation.class;
    }
    public boolean isBean() {
        return true;
    }
}
