package com.objectriver.runtime.webrpc.exception.beans.json;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.exception.beans.WebRpcExceptionCause;
import com.objectriver.runtime.webrpc.exception.beans.WebSocketException;
import com.objectriver.runtime.webrpc.exception.beans.WebSocketException_V1;
import com.objectriver.runtime.webrpc.json.*;
import com.objectriver.runtime.webrpc.json.marshals.*;
import java.sql.*;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class JsonWebSocketException_V1 extends JsonMarshal {
    public static JsonWebSocketException_V1 instance;
    static {
        instance = new JsonWebSocketException_V1();
    }
    public boolean execute(JSON jsons, JsonThing thing1)  throws WebRpcMarshallingException {
        WebSocketException request_response = (WebSocketException) thing1.getThing();
        JsonThing thing2 = new JsonThing();
            if(request_response==null) {
                request_response = new WebSocketException();
                thing1.setThing(request_response);
            }
            try {
                /**
                 * String message
                 **/
                thing2.setJvalue("message",request_response.getMessage());
                if(!json_string.instance.execute(jsons, thing2)) {
                    return false;
                }
                request_response.setMessage((String)thing2.getThing());
                jsons.separator();

                /**
                 * WebRpcExceptionCause[]  causes
                 **/
                thing2.setJvalue("causes",request_response.getCauses());
                if(!json_array(jsons, thing2, Integer.MAX_VALUE, new json_nullable(JsonWebRpcExceptionCause.instance))) {
                    return false;
                }
                request_response.setCauses((WebRpcExceptionCause[])thing2.getThing());
            }
            catch (WebRpcMarshallingException ex) {
                throw new WebRpcMarshallingException("JsonWebSocketException_V1",ex);
            }
            return true;

    }
    public Class getClazz() {
        return WebSocketException_V1.class;
    }
    public boolean isBean() {
        return true;
    }
}
