package com.objectriver.runtime.webrpc.exception.beans.xdr;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.exception.beans.WebRpcExceptionCause;
import com.objectriver.runtime.webrpc.exception.beans.WebRpcExceptionStackLocation;
import com.objectriver.runtime.webrpc.xdr.*;
import com.objectriver.runtime.webrpc.xdr.marshals.*;
import java.sql.*;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class XdrWebRpcExceptionCause extends XdrMarshal {
    public static XdrWebRpcExceptionCause instance;
    static {
        instance = new XdrWebRpcExceptionCause();
    }
    public boolean execute(XDR xdrs, XdrThing thing1)  throws WebRpcMarshallingException {
        WebRpcExceptionCause request_response = (WebRpcExceptionCause) thing1.getThing();
        XdrThing thing2 = new XdrThing();
            if(request_response==null) {
                request_response = new WebRpcExceptionCause();
                thing1.setThing(request_response);
            }
            try {
                /**
                 * String message
                 **/
                 thing2.setThing(request_response.getMessage());
                 if(!xdr_string.instance.execute(xdrs, thing2)) {
                     return false;
                 }
                 request_response.setMessage((String)thing2.getThing());
                /**
                 * String type
                 **/
                 thing2.setThing(request_response.getType());
                 if(!xdr_string.instance.execute(xdrs, thing2)) {
                     return false;
                 }
                 request_response.setType((String)thing2.getThing());
                /**
                * WebRpcExceptionStackLocation location
                **/
                thing2.setThing(request_response.getLocation());
                if(!xdr_pointer(xdrs, thing2, XdrWebRpcExceptionStackLocation.instance)) {
                    return false;
                }
                request_response.setLocation((WebRpcExceptionStackLocation)thing2.getThing());

            }
            catch (WebRpcMarshallingException ex) {
                throw new WebRpcMarshallingException("XdrWebRpcExceptionCause",ex);
            }
            return true;

    }
    public Class getClazz() {
        return WebRpcExceptionCause.class;
    }
}
