package com.objectriver.runtime.webrpc.exception.beans.xdr;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.exception.beans.WebRpcExceptionStackLocation;
import com.objectriver.runtime.webrpc.xdr.*;
import com.objectriver.runtime.webrpc.xdr.marshals.*;
import java.sql.*;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class XdrWebRpcExceptionStackLocation extends XdrMarshal {
    public static XdrWebRpcExceptionStackLocation instance;
    static {
        instance = new XdrWebRpcExceptionStackLocation();
    }
    public boolean execute(XDR xdrs, XdrThing thing1)  throws WebRpcMarshallingException {
        WebRpcExceptionStackLocation request_response = (WebRpcExceptionStackLocation) thing1.getThing();
        XdrThing thing2 = new XdrThing();
            if(request_response==null) {
                request_response = new WebRpcExceptionStackLocation(null); //todo:
                thing1.setThing(request_response);
            }
            try {
                /**
                * String declaringClass
                **/
                thing2.setThing(request_response.getDeclaringClass());
                if(!xdr_string.instance.execute(xdrs, thing2)) {
                    return false;
                }
                request_response.setDeclaringClass((String)thing2.getThing());

                /**
                * String methodName
                **/
                thing2.setThing(request_response.getMethodName());
                if(!xdr_string.instance.execute(xdrs, thing2)) {
                    return false;
                }
                request_response.setMethodName((String)thing2.getThing());

                /**
                * String fileName
                **/
                thing2.setThing(request_response.getFileName());
                if(!xdr_string.instance.execute(xdrs, thing2)) {
                    return false;
                }
                request_response.setFileName((String)thing2.getThing());

                /**
                * Integer lineNumber
                **/
                thing2.setThing(request_response.getLineNumber());
                if(!xdr_int.instance.execute(xdrs, thing2)) {
                    return false;
                }
                request_response.setLineNumber((Integer)thing2.getThing());

            }
            catch (WebRpcMarshallingException ex) {
                throw new WebRpcMarshallingException("XdrWebRpcExceptionStackLocation",ex);
            }
            return true;

    }
    public Class getClazz() {
        return WebRpcExceptionStackLocation.class;
    }
}
