package com.objectriver.runtime.webrpc.exception.beans.xdr;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.exception.beans.WebRpcExceptionCause;
import com.objectriver.runtime.webrpc.exception.beans.WebSocketException;
import com.objectriver.runtime.webrpc.exception.beans.WebSocketException_V1;
import com.objectriver.runtime.webrpc.xdr.*;
import com.objectriver.runtime.webrpc.xdr.marshals.*;
import java.sql.*;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class XdrWebSocketException_V1 extends XdrMarshal {
    public static XdrWebSocketException_V1 instance;
    static {
        instance = new XdrWebSocketException_V1();
    }
    public boolean execute(XDR xdrs, XdrThing thing1)  throws WebRpcMarshallingException {
        WebSocketException request_response = (WebSocketException) thing1.getThing();
        XdrThing thing2 = new XdrThing();
            if(request_response==null) {
                request_response = new WebSocketException();
                thing1.setThing(request_response);
            }
            try {
                {
                // String message
                thing2.setThing(request_response.getMessage());
                if(!xdr_string.instance.execute(xdrs, thing2)) {
                    return false;
                }
                request_response.setMessage((String) thing2.getThing());
                }
                {
                // WebRpcExceptionCause[] causes
                thing2.setThing(request_response.getCauses());
                if(!xdr_array(xdrs, thing2, Integer.MAX_VALUE, new xdr_nullable(XdrWebRpcExceptionCause.instance))) {
                    return false;
                }
                request_response.setCauses((WebRpcExceptionCause[]) thing2.getThing());
                }
            }
            catch (WebRpcMarshallingException ex) {
                throw new WebRpcMarshallingException("XdrWebSocketException_V1",ex);
            }
            return true;

    }
    public Class getClazz() {
        return WebSocketException_V1.class;
    }
}
