package com.objectriver.runtime.webrpc.json;

import com.objectriver.runtime.util.asserts.Assert;

import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import java.math.BigDecimal;
import java.util.LinkedList;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class JsonParserPlus implements JsonParser {
    protected final JsonParser parser;
    public JsonParserPlus(JsonParser parser) {
        this.parser = parser;
    }

    public class Quad {
        public Event event;
        public Event subevent;
        public String keyname;
        public Object value;
        public Quad(Event event, Event subevent, String keyname, Object value) {
            this.event=event;
            this.subevent=subevent;
            this.keyname= keyname;
            this.value=value;
        }
    }
    public LinkedList<Quad> eventStack = new LinkedList<Quad>();
    public Quad peek()  throws JsonParserException {
        if(!hasNext()) throw new JsonParserException("Nothing to peek!");
        Quad quad = pop();
        eventStack.addLast(quad);
        return quad;
    }
    public void push(Quad quad) {
        eventStack.addLast(quad);
    }
    public Quad pop() throws JsonParserException {
        if(!hasNext()) throw new JsonParserException("Nothing to pop!");
        if(!eventStack.isEmpty()) {
            Quad quad = eventStack.removeFirst();
            return quad;
        }
        Event event = next();
        String keyname = null;
        Event subevent = null;
        Object value = null;
        switch(event) {
            case  END_OBJECT:
            case  END_ARRAY:
                break;
            case KEY_NAME: {
                keyname = parser.getString();
                subevent = parser.next();
                value = null;
                switch(subevent) {
                case START_OBJECT:
                    event = subevent;
                    break;
                case START_ARRAY:
                    event = subevent;
                    break;
                case  VALUE_STRING:
                    value = parser.getString();
                    break;
                case  VALUE_NUMBER:
                    value = parser.getBigDecimal();
                    break;
                case  VALUE_TRUE:
                    value = Boolean.TRUE;
                case  VALUE_FALSE:
                    value = Boolean.FALSE;
                case  VALUE_NULL:
                    value = null;
                }
                break;
            }
            case  VALUE_STRING:
            case  VALUE_NUMBER:
            case  VALUE_TRUE:
            case  VALUE_FALSE:
            case  VALUE_NULL:
                throw new JsonParserException("Unexspected Event = " + event.toString());
            default:
                throw new JsonParserException("Unknown Event = " + event.toString());
        }
        return new Quad(event,subevent,keyname,value);
    }

    public Quad popArrayElement() throws JsonParserException {
        if(!hasNext()) throw new JsonParserException("Nothing to pop!");
        if(!eventStack.isEmpty()) {
            Quad quad = eventStack.removeFirst();
            return quad;
        }
        Event event = next();
        String keyname = null;
        Event subevent = null;
        Object value = null;
        switch(event) {
            case  END_OBJECT:
            case  END_ARRAY:
                value = null;
                break;
            case KEY_NAME: {
                throw new JsonParserException("Unexspected Event = " + event.toString());
            }
            case START_OBJECT:
//                event = subevent;
                break;
            case START_ARRAY:
                event = subevent;
                break;
            case  VALUE_STRING:
                value = parser.getString();
                break;
            case  VALUE_NUMBER:
                value = parser.getBigDecimal();
                 break;
            case  VALUE_TRUE:
                value = Boolean.TRUE;
                 break;
            case  VALUE_FALSE:
                value = Boolean.FALSE;
                 break;
            case  VALUE_NULL:
                value = null;
                 break;
            default:
                throw new JsonParserException("Unknown Event = " + event.toString());
        }
        return new Quad(event,subevent,keyname,value);
    }
    /**
     * Default implementation
     */
    public String getString() {
         return this.parser.getString();
     }
    public Event next() {
        if(!eventStack.isEmpty()) {
            Quad quad = eventStack.pop();
            return quad.event;
        }
        return parser.next();
    }
    public boolean hasNext() {
        if(!eventStack.isEmpty())
            return true;
        return parser.hasNext();
    }
    public boolean isIntegralNumber() {
        return this.parser.isIntegralNumber();
    }

    public int getInt(){
        return this.parser.getInt();
    }

    public long getLong(){
        return this.parser.getLong();
    }

    public BigDecimal getBigDecimal(){
        return this.parser.getBigDecimal();
    }

    public JsonLocation getLocation(){
        return this.parser.getLocation();
    }

    public void close() {
        this.parser.close();
    }
}
