package com.objectriver.runtime.webrpc.json.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.json.JSON;
import com.objectriver.runtime.webrpc.json.JsonThing;

import javax.json.stream.JsonParsingException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class json_bool extends JsonMarshal {
    public static json_bool instance;
    static {
        instance = new json_bool();
    }
    public boolean execute(JSON jsons, JsonThing thing) throws WebRpcMarshallingException {
        try {
            if (jsons.x_op == JSON.op.JSON_ENCODE) {
                Boolean bool = (Boolean)thing.getThing();
                if(bool==null) throw new WebRpcMarshallingException("json_bool() bool type can not be null! try defining as Boolean.");
                jsons.put_bool(thing.getKey(), bool);
                return true;
            }
            if (jsons.x_op == JSON.op.JSON_DECODE) {
                Boolean value = jsons.get_bool(thing.getKey());
                thing.setThing(value);
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("json_bool(): " + ex.getMessage(), ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("json_bool(): " + ex.getMessage(), ex);
        }
        catch (JsonParsingException ex) {
            throw new WebRpcMarshallingException("json_bool: " + ex.getMessage(), ex);
        }
        return false;
    }
    public Class getClazz() {
        return Boolean.class;
    }
}
