package com.objectriver.runtime.webrpc.json.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.json.JSON;
import com.objectriver.runtime.webrpc.json.JsonThing;

import javax.json.stream.JsonParsingException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class json_byte extends JsonMarshal {
    public static json_byte instance;
    static {
        instance = new json_byte();
    }
    private json_byte() {}
    public boolean execute(JSON jsons, JsonThing thing) throws WebRpcMarshallingException {
        try {
            if (jsons.x_op == JSON.op.JSON_ENCODE) {
                Byte bite = (Byte)thing.getThing();
                if(bite==null) throw new WebRpcMarshallingException("json_byte() byte type can not be null! try defining as Byte.");
                jsons.put_int(thing.getKey(), bite.intValue());
                return true;
            }
            if (jsons.x_op == JSON.op.JSON_DECODE) {
                Integer value = jsons.get_int(thing.getKey());
                thing.setThing(value.byteValue());
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("json_byte: " + ex.getMessage(), ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("json_byte: " + ex.getMessage(), ex);
        }
        catch (JsonParsingException ex) {
            throw new WebRpcMarshallingException("json_byte: " + ex.getMessage(), ex);
        }
        return false;
    }
    public Class getClazz() {
        return Byte.class;
    }
}
