package com.objectriver.runtime.webrpc.json.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.json.JSON;
import com.objectriver.runtime.webrpc.json.JsonThing;

import javax.json.stream.JsonParsingException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class json_char extends JsonMarshal {
    public static json_char instance;
    static {
        instance = new json_char();
    }
    private json_char() {}
    public boolean execute(JSON jsons, JsonThing thing) throws WebRpcMarshallingException {
        try {
            if (jsons.x_op == JSON.op.JSON_ENCODE) {
                Character chr = (Character)thing.getThing();
                if(chr==null) throw new WebRpcMarshallingException("json_char() char type can not be null! try defining as Character.");
                jsons.put_char(thing.getKey(), chr);
                return true;
            }
            if (jsons.x_op == JSON.op.JSON_DECODE) {
                Character value = jsons.get_char(thing.getKey());
                thing.setThing(value);
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("json_char: " + ex.getMessage(), ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("json_char: " + ex.getMessage(), ex);
        }
        catch (JsonParsingException ex) {
            throw new WebRpcMarshallingException("json_char: " + ex.getMessage(), ex);
        }
        return false;
    }
    public Class getClazz() {
        return Character.class;
    }
}
