package com.objectriver.runtime.webrpc.json.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.json.JSON;
import com.objectriver.runtime.webrpc.json.JsonThing;

import javax.json.stream.JsonParsingException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.sql.Date;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class json_date extends JsonMarshal {
    public static json_date instance;
    static {
        instance = new json_date();
    }
    private json_date() {}
    public boolean execute(JSON jsons, JsonThing thing) throws WebRpcMarshallingException {
        try {
            if (jsons.x_op == JSON.op.JSON_ENCODE) {
                Date date = (Date)thing.getThing();
                if(date==null) throw new WebRpcMarshallingException("json_date() date type can not be null! try defining as Date.");
                jsons.put_long(thing.getKey(), date.getTime());
                return true;
            }
            if (jsons.x_op == JSON.op.JSON_DECODE) {
                long time = jsons.get_long(thing.getKey());
                Date date = new Date(time);
                thing.setThing(date);
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("json_date: " + ex.getMessage(), ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("json_date: " + ex.getMessage(), ex);
        }
        catch (JsonParsingException ex) {
            throw new WebRpcMarshallingException("json_date: " + ex.getMessage(), ex);
        }
        return false;
    }
    public Class getClazz() {
        return Date.class;
    }
}
