package com.objectriver.runtime.webrpc.json.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.json.JSON;
import com.objectriver.runtime.webrpc.json.JsonThing;

import javax.json.stream.JsonParsingException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class json_double extends JsonMarshal {
    public static json_double instance;
    static {
        instance = new json_double();
    }
    private json_double() {}
    public boolean execute(JSON jsons, JsonThing thing) throws WebRpcMarshallingException {
        try {
            if (jsons.x_op == JSON.op.JSON_ENCODE) {
                Double dbl = (Double)thing.getThing();
                if(dbl==null) throw new WebRpcMarshallingException("json_double() double type can not be null! try defining as Double.");
                jsons.put_double(thing.getKey(), dbl);
                return true;
            }
            if (jsons.x_op == JSON.op.JSON_DECODE) {
                Double value = jsons.get_double(thing.getKey());
                thing.setThing(value);
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("json_double: " + ex.getMessage(), ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("json_double: " + ex.getMessage(), ex);
        }
        catch (JsonParsingException ex) {
            throw new WebRpcMarshallingException("json_double: " + ex.getMessage(), ex);
        }
        return false;
    }
    public Class getClazz() {
        return Double.class;
    }
}
