package com.objectriver.runtime.webrpc.json.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.json.JSON;
import com.objectriver.runtime.webrpc.json.JsonThing;

import javax.json.stream.JsonParsingException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class json_int extends JsonMarshal {
    public static json_int instance;
    static {
        instance = new json_int();
    }
    private json_int() {}
    public boolean execute(JSON jsons, JsonThing thing) throws WebRpcMarshallingException {
        try {
            if (jsons.x_op == JSON.op.JSON_ENCODE) {
                Integer nt = (Integer)thing.getThing();
                if(nt==null) throw new WebRpcMarshallingException("json_int() int type can not be null! try defining as Integer.");
                jsons.put_int(thing.getKey(), nt);
                return true;
            }
            if (jsons.x_op == JSON.op.JSON_DECODE) {
                Integer value = jsons.get_int(thing.getKey());
                thing.setThing(value);
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("json_int: " + ex.getMessage(), ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("json_int: " + ex.getMessage(), ex);
        }
        catch (JsonParsingException ex) {
            throw new WebRpcMarshallingException("json_int: " + ex.getMessage(), ex);
        }
       	if (jsons.x_op == JSON.op.JSON_FREE) {
       		return (true);
        }
        return false;
    }
    public Class getClazz() {
        return Integer.class;
    }
}
