package com.objectriver.runtime.webrpc.json.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.json.JSON;
import com.objectriver.runtime.webrpc.json.JsonThing;

import javax.json.stream.JsonParsingException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class json_long extends JsonMarshal {
    public static json_long instance;
    static {
        instance = new json_long();
    }
    private json_long() {}
    public boolean execute(JSON jsons, JsonThing thing) throws WebRpcMarshallingException {
        try {
            if (jsons.x_op == JSON.op.JSON_ENCODE) {
                Long lng = (Long)thing.getThing();
                if(lng==null) throw new WebRpcMarshallingException("json_long() long type can not be null! try defining as Long.");
                jsons.put_long(thing.getKey(), lng);
                return true;
            }
            if (jsons.x_op == JSON.op.JSON_DECODE) {
                Long value = jsons.get_long(thing.getKey());
                thing.setThing(value);
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("json_long: " + ex.getMessage(), ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("json_long: " + ex.getMessage(), ex);
        }
        catch (JsonParsingException ex) {
            throw new WebRpcMarshallingException("json_long: " + ex.getMessage(), ex);
        }
        return false;
    }
    public Class getClazz() {
        return Long.class;
    }
}
