/*
 * *
 *  * ObjectRiver Inc, http://www.objectriver.net/
 *  * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 *
 */

package com.objectriver.runtime.webrpc.json.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.json.JSON;
import com.objectriver.runtime.webrpc.json.JsonProcT;
import com.objectriver.runtime.webrpc.json.JsonThing;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public class json_nullable extends JsonMarshal {
    private final JsonProcT procT;
    private final boolean isString;
    public json_nullable(JsonProcT procT) {
        this.procT = procT;
        this.isString = (procT == json_string.instance );
    }
    public boolean execute(JSON jsons, JsonThing thing) throws WebRpcMarshallingException {
        try {
            if(isString) {
                return procT.execute(jsons, thing);
            }
            else {
                return json_pointer(jsons, thing, procT);
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("json_nullable", ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("json_nullable", ex);
        }
    }
    public Class getClazz() {
        return procT.getClazz();
    }
    public boolean isBean() { return procT.isBean(); }
}
