package com.objectriver.runtime.webrpc.json.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.json.JSON;
import com.objectriver.runtime.webrpc.json.JsonThing;

import javax.json.stream.JsonParsingException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class json_short extends JsonMarshal {
    public static json_short instance;
    static {
        instance = new json_short();
    }
    private json_short() {}
    public boolean execute(JSON jsons, JsonThing thing) throws WebRpcMarshallingException {
        try {
            if (jsons.x_op == JSON.op.JSON_ENCODE) {
                Short shrt = (Short)thing.getThing();
                if(shrt==null) throw new WebRpcMarshallingException("json_short() short type can not be null! try defining as Short.");
                jsons.put_int(thing.getKey(), shrt.intValue());
                return true;
            }
            if (jsons.x_op == JSON.op.JSON_DECODE) {
                Integer value = jsons.get_int(thing.getKey());
                thing.setThing(value.shortValue());
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("json_short: " + ex.getMessage(), ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("json_short: " + ex.getMessage(), ex);
        }
        catch (JsonParsingException ex) {
            throw new WebRpcMarshallingException("json_short: " + ex.getMessage(), ex);
        }
        return false;
    }
    public Class getClazz() {
        return Short.class;
    }
}
