package com.objectriver.runtime.webrpc.json;

import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.json.marshals.json_float;
import com.objectriver.runtime.webrpc.json.marshals.json_int;
import com.objectriver.runtime.webrpc.json.marshals.json_string;

import java.io.StringReader;
import java.io.StringWriter;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class testJson {
    public static void main(String[] args) {
        StringWriter bb = new StringWriter(5000);
        JSON jsons = new JSON(bb);
        try {
            jsons.startDocument();



                //encode
                Integer intbefore = Integer.valueOf(1234);
                JsonThing thing = new JsonThing("myInt",intbefore);
                json_int.instance.execute(jsons,thing);
                jsons.separator();

                String special = "!@#$%\n^&*(){}[]\\|\"'<>,.?/";
                thing.setJvalue("special", special);
                json_string.instance.execute(jsons,thing);
                jsons.separator();

                thing.setJvalue("myString", "chester");
                json_string.instance.execute(jsons,thing);
                jsons.separator();

                Float f = Float.valueOf((float)1234.5678);
                thing.setJvalue("myFloat", f);
                json_float.instance.execute(jsons, thing);
                jsons.separator();

                thing.setJvalue("nullString",null);
                json_string.instance.execute(jsons, thing);
                jsons.separator();

                thing.setJvalue("intPointer",null);
                json_int.instance.json_pointer(jsons,thing.setThing(intbefore),json_int.instance);  // pointer to int
                jsons.separator();
                json_int.instance.json_pointer(jsons,thing.setThing(null),json_int.instance);  // null pointer to int
                jsons.separator();
//
                String[] strarray = new String[] { "1","fred","3" };
                thing.setJvalue("strArray",strarray);
                json_string.instance.json_array(jsons,thing,json_string.instance);
            jsons.endDocument();


            //decode

            StringReader bb2 = new StringReader(bb.toString());
            jsons = new JSON(bb2);
            jsons.startDocument();

            JsonThing thing2 = new JsonThing();
            json_int.instance.execute(jsons, thing2.setKey("myInt"));
            Assert.assertTrue("Integer failed", intbefore.equals(thing2.getThing()));

            json_string.instance.execute(jsons,thing2.setKey("special"));
            Assert.assertTrue("String failed", special.equals(thing2.getThing()));
            jsons.separator();

            json_string.instance.execute(jsons, thing2.setKey("myString"));
            Assert.assertTrue("String failed", "chester".equals(thing2.getThing()));

            json_float.instance.execute(jsons, thing2.setKey("myFloat"));
            Assert.assertTrue("String failed", f.equals(thing2.getThing()));

            json_string.instance.execute(jsons, thing2.setKey("nullString"));
            Assert.assertTrue("String failed", thing2.getThing() == null);

            json_int.instance.json_pointer(jsons, thing2.setJvalue("intPointer", intbefore), json_int.instance);
            Assert.assertTrue("Integer failed", intbefore.equals(thing2.getThing()));

            json_int.instance.json_pointer(jsons,thing2.setJvalue("intPointer", null),json_int.instance);
            Assert.assertTrue("Integer failed", thing2.getThing()==null);

            json_int.instance.json_array(jsons, thing2.setJvalue("strArray", null), json_string.instance);
            String[] array = (String[]) thing2.getThing();
            Assert.assertTrue("Integer failed", array[0].equals("1"));
            Assert.assertTrue("Integer failed", array[1].equals("fred"));
            Assert.assertTrue("Integer failed", array[2].equals("3"));
            jsons.endDocument();
        }
        catch(WebRpcMarshallingException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }
}
