package com.objectriver.runtime.webrpc.properties;

import com.objectriver.runtime.webrpc.exception.WebRpcRuntimeException;

import java.io.*;
import java.net.URL;
import java.util.Properties;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
/**
 * This routine loads properties file from env variable definitions.
 */
public class WebRpcProperties {
    public static Properties getPropertiesFromEnv(String envdir,String filename) throws WebRpcRuntimeException {
        String propdir = System.getenv(envdir);
        if(propdir==null) {
            throw new WebRpcRuntimeException("Property " +  envdir + " env varaible not defined");
        }
        File propfile = new File(propdir + File.separator + filename);
        return WebRpcProperties.getPropertiesFromFile(propfile);
    }
    /**
     * This routine loads properties from the file system
     */
    public static Properties getPropertiesFromFile(File file) throws WebRpcRuntimeException {
        try {
            if(!file.exists()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            Properties webrpcProperties = new Properties();
            InputStream stream = new FileInputStream(file);
            webrpcProperties.load(stream);
            stream.close();
            return webrpcProperties;
        } catch (FileNotFoundException fnfe) {
            throw new WebRpcRuntimeException("Properties file " +  file.getName() + " file not found", fnfe);
        } catch (IOException ioe) {
            throw new WebRpcRuntimeException("Properties file " +  file.getName() + "IOException", ioe);
        }
    }

    /**
     * This routine loads properties within the jar file
     */
    public static Properties getProperties(String fileName) throws WebRpcRuntimeException {
        try {
            // load the properties file from the top of the class path
            Properties webrpcProperties = new Properties();
            URL url = Properties.class.getResource("/" + fileName );
            if(url==null)
                throw new WebRpcRuntimeException("Properties file " + fileName + " file not found");
            InputStream stream = url.openStream();
            webrpcProperties.load(stream);
            stream.close();
            return webrpcProperties;
        } catch (FileNotFoundException fnfe) {
            throw new WebRpcRuntimeException("Properties file " +  fileName + " file not found", fnfe);
        } catch (IOException ioe) {
            throw new WebRpcRuntimeException("Properties file " +  fileName + "IOException", ioe);
        }
    }
}
