package com.objectriver.runtime.webrpc.server;

import com.objectriver.runtime.webrpc.exception.WebRpcServerException;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class Server {
    public void launch(String serverType, String host, int port, String rootPath, Class serverApplicationConfig) throws WebRpcServerException {
        ServerType sType = ServerType.valueOf(serverType);
        if(sType==null) throw new WebRpcServerException("Unknown server type? " + serverType);
        try {
            switch (sType.intValue()) {
                case ServerType.tyrusInt:
                case ServerType.glassfishInt: {
                    Class serverClass = Class.forName("org.glassfish.tyrus.server.Server");
                    Constructor serverConstructor = serverClass.getConstructor(
                            new Class[] {String.class, int.class, String.class, Map.class, Class[].class}
                    );
//                    Object serverObj = serverConstructor.newInstance(host, Integer.valueOf(port), rootPath, Collections.<String,Object>emptyMap(), new Class[]{serverApplicationConfig});
                    Object[] args = new Object[]{host, Integer.valueOf(port), rootPath, Collections.<String,Object>emptyMap(), new Class[]{serverApplicationConfig}};
                    Object serverObj = serverConstructor.newInstance(args);
                    Method startMethod = serverClass.getMethod("start", null);
                    startMethod.invoke(serverObj, null);
                    synchronized (this) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException  ex) {}
                    }
                    break;
                }
                case ServerType.tomcatInt:
                case ServerType.jettyInt:
                case ServerType.jbossInt:
                case ServerType.weblogicInt:
                case ServerType.websphereInt:
                    throw new WebRpcServerException("Server type " + serverType + " not supported yet :( Try tyrus as workaround for now.");
                default: {
                    throw new WebRpcServerException("Unknown server type: " + serverType);
                }
            }
        }

        catch (ClassNotFoundException ex) {
            throw new WebRpcServerException("ClassNotFound exception trying to launch " + serverType + " Server. Check webrpc.properties and classpath", ex);
        }
        /**
         * Reflection errors
         */
        catch (InstantiationException  ex) {
            throw new WebRpcServerException("Reflection exception trying to launch " + serverType + " Server.", ex);
        }
        catch (NoSuchMethodException  ex) {
            throw new WebRpcServerException("Reflection exception trying to launch " + serverType + " Server.", ex);
        }
        catch (InvocationTargetException ex) {
            throw new WebRpcServerException("Reflection exception trying to launch " + serverType + " Server.", ex);
        }
        catch (IllegalAccessException  ex) {
            throw new WebRpcServerException("Reflection exception trying to launch " + serverType + " Server.", ex);
        }
    }
    public synchronized void shutdown()  {
        this.notify();
    }
}
