package com.objectriver.runtime.webrpc.util;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *                             NOTICE
 *               COPYRIGHT (c) 2016 ObjectRiver Inc
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 */
public class ISO8601DateTimeSingleton {
    static private DateFormat timestampformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    static private DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd'T'00:00:00.000'Z'");
    static private ISO8601DateTimeSingleton instance = new ISO8601DateTimeSingleton();
    private ISO8601DateTimeSingleton() {};
    public static ISO8601DateTimeSingleton getInstance() {
        return instance;
    }
    public String getIsoDate(Date date) {
        String isodate;
        synchronized (dateformat) {
            isodate = dateformat.format(date);
        }
        return isodate;
    }
    public String getIsoDate(Timestamp ts) {
        String isots;
        synchronized (timestampformat) {
            isots = timestampformat.format(ts);
        }
        return isots;
    }
    public <T extends java.util.Date> T parseDateTime(T datetype, String isodate) throws java.text.ParseException {
        java.util.Date utilDate;
        isodate = constructIsoDateTime(isodate);
        synchronized (timestampformat) {
            utilDate = timestampformat.parse(isodate);
        }
        datetype.setTime(utilDate.getTime());
        return datetype;
    }

    public static void main(String[] agrs) {
        System.out.println(constructIsoDateTime("2018-12-12"));
        System.out.println(constructIsoDateTime("2018-12-12 12:12:12"));
        System.out.println(constructIsoDateTime("2018-12-12 12:12:12.123"));
        System.out.println(constructIsoDateTime("2018-12-12T12:12:12.123Z"));
        System.out.println(constructIsoDateTime("2018-12-12T12:12:12.123+0000"));
    }

    private static final Pattern pattern = Pattern.compile("^(\\d\\d\\d\\d-\\d\\d-\\d\\d)([T ]?(\\d\\d:\\d\\d:\\d\\d)?[.]?(\\d\\d\\d)?([Z]|\\+\\d\\d\\d\\d)?)?");
    private static String constructIsoDateTime(String isodate) {
        if(isodate.length()>8 && isodate.charAt(4)=='-') {
            Matcher matcher = pattern.matcher(isodate);
            if (matcher.matches()) {
                if (matcher.group(1) != null) {
                    isodate = matcher.group(1);
                }
                if (matcher.group(3) != null) {
                    isodate += ('T' + matcher.group(3));
                    if (matcher.group(4) != null) {
                        isodate += ('.' + matcher.group(4) + 'Z');
                    } else {
                        isodate += ".000Z";
                    }
                } else {
                    isodate += "T00:00:00.00Z";
                }
            }
        }
        return isodate;
    }
}
