package com.objectriver.runtime.webrpc.xdr;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;

import java.io.*;
import java.nio.ByteBuffer;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class XDR {
    public DataInputStream instream;
    public DataOutputStream outstream;
    public ByteBuffer byteBuffer=null;
    public static final int BYTES_PER_XDR_UNIT	= 1;
    public static final byte XDR_TRUE = Byte.valueOf((byte)1);
    public static final byte XDR_FALSE = Byte.valueOf((byte)0);
    public enum op {
        XDR_ENCODE,
        XDR_DECODE,
        XDR_FREE
    };

    private XDR(){}
    public XDR(InputStream input) {
        instream = new DataInputStream(input);
        x_op = op.XDR_DECODE;
    }
    public XDR(OutputStream output) {
        outstream = new DataOutputStream(output);
        x_op = op.XDR_ENCODE;
    }
    public XDR(ByteBuffer bb, XDR.op op) {
        byteBuffer = bb;
        x_op = op;
    }

    public void close() {
        try{
            if(byteBuffer==null) {
                if(x_op==op.XDR_DECODE) {
                    instream.close();
                }
                else {
                    outstream.close();
                }
            }
        }
        catch(IOException ex) {}
    }

    public op x_op;
    public op getX_op() {
        return x_op;
    }
    public void setX_op(op x_op) {
        this.x_op = x_op;
    }
    public int version;
    public int getVersion() {
        return version;
    }
    public void setVersion(int envelope_version) {
        this.version = envelope_version;
    }
    public void put_int(Integer value)  throws WebRpcMarshallingException {
        if(this.byteBuffer==null) {
            try {
                outstream.writeInt(value);
            }
            catch(IOException ioex) {
                throw new WebRpcMarshallingException("put_int()",ioex);
            }
        }
        else {
            byteBuffer.putInt(value);
        }
    }
    public Integer get_int() throws WebRpcMarshallingException   {
        if(byteBuffer==null) {
            try {
                return instream.readInt();
            }
            catch(IOException ioex) {
                throw new WebRpcMarshallingException("get_int()",ioex);
            }
        }
        else {
            return byteBuffer.getInt();
        }
    }

    public void put_long(Long value) throws WebRpcMarshallingException   {
        if(this.byteBuffer==null) {
            try {
                outstream.writeLong(value);
            }
            catch(IOException ioex) {
                throw new WebRpcMarshallingException("put_long()",ioex);
            }
        }
        else {
            byteBuffer.putLong(value);
        }
    }
    public Long get_long() throws WebRpcMarshallingException   {
        if(this.byteBuffer==null) {
            try {
                return instream.readLong();
            }
            catch(IOException ioex) {
                throw new WebRpcMarshallingException("get_long()",ioex);
            }
        }
        else {
            return byteBuffer.getLong();
        }
    }

    public void put_float(Float value) throws WebRpcMarshallingException   {
        if(this.byteBuffer==null) {
            try {
                outstream.writeFloat(value);
            }
            catch(IOException ioex) {
                throw new WebRpcMarshallingException("put_float()",ioex);
            }
        }
        else {
            byteBuffer.putFloat(value);
        }
    }
    public Float get_float() throws WebRpcMarshallingException   {
        if(this.byteBuffer==null) {
            try {
                return instream.readFloat();
            }
            catch(IOException ioex) {
                throw new WebRpcMarshallingException("get_float()",ioex);
            }
        }
        else {
            return byteBuffer.getFloat();
        }
    }

    public void put_double(Double value) throws WebRpcMarshallingException   {
        if(this.byteBuffer==null) {
            try {
                outstream.writeDouble(value);
            }
            catch(IOException ioex) {
                throw new WebRpcMarshallingException("put_double()",ioex);
            }
        }
        else {
            byteBuffer.putDouble(value);
        }
    }
    public Double get_double() throws WebRpcMarshallingException   {
        if(this.byteBuffer==null) {
            try {
                return instream.readDouble();
            }
            catch(IOException ioex) {
                throw new WebRpcMarshallingException("get_double()",ioex);
            }
        }
        else {
            return byteBuffer.getDouble();
        }
    }

    public void put_char(Character value) throws WebRpcMarshallingException   {
        if(this.byteBuffer==null) {
            try {
                outstream.writeChar(value);
            }
            catch(IOException ioex) {
                throw new WebRpcMarshallingException("put_char()",ioex);
            }
        }
        else {
            byteBuffer.putChar(value);
        }
    }
    public Character get_char() throws WebRpcMarshallingException   {
        if(this.byteBuffer==null) {
            try {
                return instream.readChar();
            }
            catch(IOException ioex) {
                throw new WebRpcMarshallingException("get_char()",ioex);
            }
        }
        else {
            return byteBuffer.getChar();
        }
    }

    public void put_byte(byte value) throws WebRpcMarshallingException   {
        if(this.byteBuffer==null) {
            try {
                outstream.write(value);
            }
            catch(IOException ioex) {
                throw new WebRpcMarshallingException("put_byte()",ioex);
            }
        }
        else {
            byteBuffer.put(value);
        }
    }
    public byte get_byte() throws WebRpcMarshallingException   {
        if(this.byteBuffer==null) {
            try {
                return instream.readByte();
            }
            catch(IOException ioex) {
                throw new WebRpcMarshallingException("get_byte()",ioex);
            }
        }
        else {
            return byteBuffer.get();
        }
    }
    public void put_bytes(byte[] value, int length) throws WebRpcMarshallingException   {
        if(this.byteBuffer==null) {
            try {
                outstream.write(value, 0, length);
            }
            catch(IOException ioex) {
                throw new WebRpcMarshallingException("put_bytes()",ioex);
            }
        }
        else {
            byteBuffer.put(value, 0, length);
        }
    }
    public byte[] get_bytes(byte[] value, int length) throws WebRpcMarshallingException   {
        if(this.byteBuffer==null) {
            try {
                instream.read(value,0,length);
            }
            catch(IOException ioex) {
                throw new WebRpcMarshallingException("get_bytes()",ioex);
            }
        }
        else {
            byteBuffer.get(value, 0, length);
        }
        return value;
    }
}
