package com.objectriver.runtime.webrpc.xdr.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.xdr.XDR;
import com.objectriver.runtime.webrpc.xdr.XdrProcT;
import com.objectriver.runtime.webrpc.xdr.XdrThing;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class xdr_bool extends XdrMarshal {
    public static xdr_bool instance;
    static {
        instance = new xdr_bool();
    }
    public boolean execute(XDR xdrs, XdrThing thing) throws WebRpcMarshallingException {
        try {
            if (xdrs.x_op == XDR.op.XDR_ENCODE) {
                Boolean bool = (Boolean)thing.getThing();
                if(bool==null) throw new WebRpcMarshallingException("xdr_bool() bool type can not be null! try defining as Boolean.");
                xdrs.put_byte(bool?XDR.XDR_TRUE:XDR.XDR_FALSE);
                return true;
            }
            if (xdrs.x_op == XDR.op.XDR_DECODE) {
                byte longbool = xdrs.get_byte();
                thing.setThing((longbool==0)?Boolean.FALSE:Boolean.TRUE);
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("xdr_bool()", ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("xdr_bool()", ex);
        }

       	if (xdrs.x_op == XDR.op.XDR_FREE) {
       		return (true);
        }
        return false;
    }
    public Class getClazz() {
        return Boolean.class;
    }
}
