package com.objectriver.runtime.webrpc.xdr.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.xdr.XDR;
import com.objectriver.runtime.webrpc.xdr.XdrThing;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class xdr_byte extends XdrMarshal {
    public static xdr_byte instance;
    static {
        instance = new xdr_byte();
    }
    private xdr_byte() {}
    public boolean execute(XDR xdrs, XdrThing thing) throws WebRpcMarshallingException {
        try {
            if (xdrs.x_op == XDR.op.XDR_ENCODE) {
                Byte byt = (Byte)thing.getThing();
                if(byt==null) throw new WebRpcMarshallingException("xdr_byte() byte type can not be null! try defining as Byte.");
                xdrs.put_int(byt.intValue());
                return true;
            }
            if (xdrs.x_op == XDR.op.XDR_DECODE) {
                Integer byt = xdrs.get_int();
                thing.setThing(byt.byteValue());
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("xdr_byte", ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("xdr_byte", ex);
        }
        return false;
    }
    public Class getClazz() {
        return Byte.class;
    }
}
