package com.objectriver.runtime.webrpc.xdr.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.xdr.XDR;
import com.objectriver.runtime.webrpc.xdr.XdrProcT;
import com.objectriver.runtime.webrpc.xdr.XdrThing;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class xdr_double extends XdrMarshal {
    public static xdr_double instance;
    static {
        instance = new xdr_double();
    }
    private xdr_double() {}
    public boolean execute(XDR xdrs, XdrThing thing) throws WebRpcMarshallingException {
        try {
            if (xdrs.x_op == XDR.op.XDR_ENCODE) {
                Double dbl = (Double)thing.getThing();
                if(dbl==null) throw new WebRpcMarshallingException("xdr_double() double type can not be null! try defining as Double.");
                xdrs.put_double(dbl);
                return true;
            }
            if (xdrs.x_op == XDR.op.XDR_DECODE) {
                thing.setThing(xdrs.get_double());
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("xdr_double", ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("xdr_double", ex);
        }

       	if (xdrs.x_op == XDR.op.XDR_FREE) {
       		return (true);
        }
        return false;
    }
    public Class getClazz() {
        return Double.class;
    }
}
