package com.objectriver.runtime.webrpc.xdr.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.xdr.XDR;
import com.objectriver.runtime.webrpc.xdr.XdrProcT;
import com.objectriver.runtime.webrpc.xdr.XdrThing;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class xdr_float extends XdrMarshal {
    public static xdr_float instance;
    static {
        instance = new xdr_float();
    }
    private xdr_float() {}
    public boolean execute(XDR xdrs, XdrThing thing) throws WebRpcMarshallingException {
        try {
            if (xdrs.x_op == XDR.op.XDR_ENCODE) {
                Float flt = (Float)thing.getThing();
                if(flt==null) throw new WebRpcMarshallingException("xdr_float() float type can not be null! try defining as Float.");
                xdrs.put_float(flt);
                return true;
            }
            if (xdrs.x_op == XDR.op.XDR_DECODE) {
                thing.setThing(xdrs.get_float());
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("xdr_float", ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("xdr_float", ex);
        }

       	if (xdrs.x_op == XDR.op.XDR_FREE) {
       		return (true);
        }
        return false;
    }
    public Class getClazz() {
        return Float.class;
    }
}
